/****************************************************************************
 *
 * File:            Profile.java
 *
 * Description:     PDFTOOLS Profile Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdf2image.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The base class for PDF to image conversion profiles</h1>
 * The profile defines how the PDF pages are rendered and what type of output image is used.
 * A profile implements the converter settings suitable for a practical
 * use case, e.g. create images for sending over Facsimile, for
 * viewing, or for archiving.
 */
public abstract class Profile extends NativeObject 
{
    protected Profile(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Profile createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.pdf2image.profiles.Fax.createDynamicObject(handle);
            case 2:
                return com.pdftools.pdf2image.profiles.Archive.createDynamicObject(handle);
            case 3:
                return com.pdftools.pdf2image.profiles.Viewing.createDynamicObject(handle);
            default:
                return null;
        }
    }




     /**
     * <h1>The parameters how to render PDF content elements (Getter)</h1>
     * 
     */
    public com.pdftools.pdf2image.ContentOptions getContentOptions()
    {
        long retHandle = getContentOptionsNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf2image.ContentOptions.createDynamicObject(retHandle);

    }




    private static native int getType(long handle);
    private native long getContentOptionsNative(long handle);

}

