/****************************************************************************
 *
 * File:            AFRelationship.java
 *
 * Description:     AFRelationship Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdfa.conversion;

/**
 * 
 * The AFRelationship determines the relation of the embedded file to the PDF.
 */
public enum AFRelationship  
{
    /**
     * 
     * The file specification is the original source material for the associated content.
     */
    SOURCE(1),
    /**
     * 
     * The file specification represents information used to derive a visual presentation – such as for a table or a graph.
     */
    DATA(2),
    /**
     * 
     * The file specification is an alternative representation of content, for example audio
     */
    ALTERNATIVE(3),
    /**
     * 
     * The file specification represents a supplemental representation of the original source or data that may be more easily consumable.
     */
    SUPPLEMENT(4),
    /**
     * 
     * The relationship is not known or cannot be described using one of the other values.
     */
    UNSPECIFIED(5);

    AFRelationship(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static AFRelationship fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return SOURCE;
            case 2: return DATA;
            case 3: return ALTERNATIVE;
            case 4: return SUPPLEMENT;
            case 5: return UNSPECIFIED;
        }
        throw new IllegalArgumentException("Unknown value for AFRelationship: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
