/****************************************************************************
 *
 * File:            EventCode.java
 *
 * Description:     EventCode Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdfa.conversion;

/**
 * <h1>The code identifying particular conversion events</h1>
 * See {@link Converter.ConversionEventListener } for more information on conversion events.
 */
public enum EventCode  
{
    /**
     * 
     * Code for events that do not have a specific code associated.
     */
    GENERIC(0x00000001),
    /**
     * 
     * see {@link EventCategory#VISUAL_DIFFERENCES }
     */
    REMOVED_XFA(0x01000000),
    /**
     * 
     * see {@link EventCategory#VISUAL_DIFFERENCES }
     */
    FONT_NON_EMBEDDED_ORDERING_IDENTITY(0x01000001),
    /**
     * 
     * see {@link EventCategory#VISUAL_DIFFERENCES }
     */
    FONT_NO_ROTATE(0x01000002),
    /**
     * 
     * see {@link EventCategory#VISUAL_DIFFERENCES }
     */
    FONT_NO_ITALIC_SIMULATION(0x01000003),
    /**
     * 
     * see {@link EventCategory#VISUAL_DIFFERENCES }
     */
    CLIPPED_NUMBER_VALUE(0x01000004),
    /**
     * 
     * see {@link EventCategory#REPAIRED_CORRUPTION }
     */
    RECOVERED_IMAGE_SIZE(0x02000000),
    /**
     * 
     * see {@link EventCategory#REPAIRED_CORRUPTION }
     */
    REPAIRED_FONT(0x02000001),
    /**
     * 
     * see {@link EventCategory#MANAGED_COLORS }
     */
    COPIED_OUTPUT_INTENT(0x03000000),
    /**
     * 
     * see {@link EventCategory#MANAGED_COLORS }
     */
    SET_OUTPUT_INTENT(0x03000001),
    /**
     * 
     * see {@link EventCategory#MANAGED_COLORS }
     */
    GENERATED_OUTPUT_INTENT(0x03000002),
    /**
     * 
     * see {@link EventCategory#MANAGED_COLORS }
     */
    SET_COLOR_PROFILE(0x03000003),
    /**
     * 
     * see {@link EventCategory#MANAGED_COLORS }
     */
    GENERATED_COLOR_PROFILE(0x03000004),
    /**
     * 
     * see {@link EventCategory#MANAGED_COLORS }
     */
    CREATED_CALIBRATED(0x03000005),
    /**
     * 
     * see {@link EventCategory#CHANGED_COLORANT }
     */
    RENAMED_COLORANT(0x04000000),
    /**
     * 
     * see {@link EventCategory#CHANGED_COLORANT }
     */
    RESOLVED_COLORANT_COLLISION(0x04000001),
    /**
     * 
     * see {@link EventCategory#CONVERTED_FONT }
     */
    EMBEDED_FONT(0x06000000),
    /**
     * 
     * see {@link EventCategory#SUBSTITUTED_FONT }
     */
    SUBSTITUTED_FONT(0x07000000),
    /**
     * 
     * see {@link EventCategory#SUBSTITUTED_FONT }
     */
    SUBSTITUTED_MULTIPLE_MASTER(0x07000001),
    /**
     * 
     * see {@link EventCategory#REMOVED_ANNOTATION }
     */
    CONVERTED_TO_STAMP(0x09000000),
    /**
     * 
     * see {@link EventCategory#REMOVED_METADATA }
     */
    REMOVED_DOCUMENT_METADATA(0x0C000000),
    /**
     * 
     * see {@link EventCategory#CONVERTED_EMBEDDED_FILE }
     */
    COPIED_EMBEDDED_FILE(0x0F000000),
    /**
     * 
     * see {@link EventCategory#CONVERTED_EMBEDDED_FILE }
     */
    CONVERTING_EMBEDDED_FILE_START(0x0F000001),
    /**
     * 
     * see {@link EventCategory#CONVERTED_EMBEDDED_FILE }
     */
    CONVERTING_EMBEDDED_FILE_SUCCESS(0x0F000002),
    /**
     * 
     * see {@link EventCategory#REMOVED_EMBEDDED_FILE }
     */
    CHANGED_TO_INITIAL_DOCUMENT(0x10000000),
    /**
     * 
     * see {@link EventCategory#REMOVED_EMBEDDED_FILE }
     */
    CONVERTING_EMBEDDED_FILE_ERROR(0x10000001),
    /**
     * 
     * see {@link EventCategory#REMOVED_EMBEDDED_FILE }
     */
    REMOVED_EMBEDDED_FILE(0x10000002),
    /**
     * 
     * see {@link EventCategory#REMOVED_EMBEDDED_FILE }
     */
    REMOVED_FILE_ATTACHMENT_ANNOTATION(0x10000003);

    EventCode(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static EventCode fromValue(int value) 
    {
        switch (value) 
        {
            case 0x00000001: return GENERIC;
            case 0x01000000: return REMOVED_XFA;
            case 0x01000001: return FONT_NON_EMBEDDED_ORDERING_IDENTITY;
            case 0x01000002: return FONT_NO_ROTATE;
            case 0x01000003: return FONT_NO_ITALIC_SIMULATION;
            case 0x01000004: return CLIPPED_NUMBER_VALUE;
            case 0x02000000: return RECOVERED_IMAGE_SIZE;
            case 0x02000001: return REPAIRED_FONT;
            case 0x03000000: return COPIED_OUTPUT_INTENT;
            case 0x03000001: return SET_OUTPUT_INTENT;
            case 0x03000002: return GENERATED_OUTPUT_INTENT;
            case 0x03000003: return SET_COLOR_PROFILE;
            case 0x03000004: return GENERATED_COLOR_PROFILE;
            case 0x03000005: return CREATED_CALIBRATED;
            case 0x04000000: return RENAMED_COLORANT;
            case 0x04000001: return RESOLVED_COLORANT_COLLISION;
            case 0x06000000: return EMBEDED_FONT;
            case 0x07000000: return SUBSTITUTED_FONT;
            case 0x07000001: return SUBSTITUTED_MULTIPLE_MASTER;
            case 0x09000000: return CONVERTED_TO_STAMP;
            case 0x0C000000: return REMOVED_DOCUMENT_METADATA;
            case 0x0F000000: return COPIED_EMBEDDED_FILE;
            case 0x0F000001: return CONVERTING_EMBEDDED_FILE_START;
            case 0x0F000002: return CONVERTING_EMBEDDED_FILE_SUCCESS;
            case 0x10000000: return CHANGED_TO_INITIAL_DOCUMENT;
            case 0x10000001: return CONVERTING_EMBEDDED_FILE_ERROR;
            case 0x10000002: return REMOVED_EMBEDDED_FILE;
            case 0x10000003: return REMOVED_FILE_ATTACHMENT_ANNOTATION;
        }
        throw new IllegalArgumentException("Unknown value for EventCode: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
