/****************************************************************************
 *
 * File:            InvoiceType.java
 *
 * Description:     InvoiceType Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdfa.conversion;

/**
 * 
 */
public enum InvoiceType  
{
    /**
     * 
     * ZUGFeRD (version and profile are determined automatically).
     */
    ZUGFERD(1),
    /**
     * 
     * Factur-X (version and profile are determined automatically).
     */
    FACTUR_X(2);

    InvoiceType(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static InvoiceType fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return ZUGFERD;
            case 2: return FACTUR_X;
        }
        throw new IllegalArgumentException("Unknown value for InvoiceType: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
