/****************************************************************************
 *
 * File:            ValidationResult.java
 *
 * Description:     PDFTOOLS ValidationResult Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.pdfa.validation;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The PDF validation result</h1>
 * Result of the validator's method {@link Validator#validate }.
 */
public class ValidationResult extends NativeObject 
{
    protected ValidationResult(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ValidationResult createDynamicObject(long handle)
    {
        return new ValidationResult(handle);
    }




     /**
     * <h1>The validated conformance (Getter)</h1>
     * 
     */
    public com.pdftools.pdf.Conformance getConformance()
    {
        int retVal = getConformanceNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return new com.pdftools.pdf.Conformance(retVal);

    }


     /**
     * <h1>Whether the document is conforming (Getter)</h1>
     * Whether the document conforms to all standards referenced to the {@link ValidationResult#getConformance }.
     * Any issues found are reported as {@link Validator.ErrorListener }.
     */
    public boolean getIsConforming()
    {
        boolean retVal = getIsConformingNative(getHandle());
        if (!retVal)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }




    private native int getConformanceNative(long handle);
    private native boolean getIsConformingNative(long handle);

}

