/****************************************************************************
 *
 * File:            AddValidationInformation.java
 *
 * Description:     AddValidationInformation Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.sign;

/**
 * 
 */
public enum AddValidationInformation  
{
    /**
     * 
     * Do not add validation information to any existing signatures of input document.
     */
    NONE(1),
    /**
     * 
     * Add validation information to latest existing signature of input document.
     */
    LATEST(2),
    /**
     * 
     * Add validation information to all existing signatures of input document.
     */
    ALL(3);

    AddValidationInformation(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static AddValidationInformation fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return NONE;
            case 2: return LATEST;
            case 3: return ALL;
        }
        throw new IllegalArgumentException("Unknown value for AddValidationInformation: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
