/****************************************************************************
 *
 * File:            MdpPermissionOptions.java
 *
 * Description:     PDFTOOLS MdpPermissionOptions Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.sign;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The permission options when certifying a document</h1>
 */
public class MdpPermissionOptions extends NativeObject 
{
    protected MdpPermissionOptions(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static MdpPermissionOptions createDynamicObject(long handle)
    {
        return new MdpPermissionOptions(handle);
    }


    /**
     * 
     * @param permissions 
     * @throws IllegalArgumentException if {@code permissions} is {@code null}
     */
    public MdpPermissionOptions(com.pdftools.pdf.MdpPermissions permissions)
    {
        this(newHelper(permissions));
    }

    private static long newHelper(com.pdftools.pdf.MdpPermissions permissions)
    {
        if (permissions == null)
            throw new IllegalArgumentException("Argument 'permissions' must not be null.", new NullPointerException("'permissions'"));

        long handle = newNative(permissions.getValue());
        if (handle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return handle;
    }



     /**
     * <h1>The access permissions granted for the document (Getter)</h1>
     * 
     */
    public com.pdftools.pdf.MdpPermissions getPermissions()
    {
        int retVal = getPermissionsNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf.MdpPermissions.fromValue(retVal);
    }

     /**
     * <h1>The access permissions granted for the document (Setter)</h1>
     * 
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setPermissions(com.pdftools.pdf.MdpPermissions value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setPermissionsNative(getHandle(), value.getValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private static native long newNative(int permissions);
    private native int getPermissionsNative(long handle);
    private native boolean setPermissionsNative(long handle, int value);

}

