/****************************************************************************
 *
 * File:            PreparedDocument.java
 *
 * Description:     PDFTOOLS PreparedDocument Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.sign;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>A document that has been prepared for signing</h1>
 */
public class PreparedDocument extends com.pdftools.pdf.Document 
{
    protected PreparedDocument(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static PreparedDocument createDynamicObject(long handle)
    {
        return new PreparedDocument(handle);
    }



    /**
     * <h1>Calculate the hash value</h1>
     * Calculate the hash value to create the signature from.
     * @param algorithm 
     * The hash algorithm
     * @return 
     * @throws IllegalArgumentException if {@code algorithm} is {@code null}
     */
    public byte[] getHash(com.pdftools.crypto.HashAlgorithm algorithm) 
    {
        if (algorithm == null)
            throw new IllegalArgumentException("Argument 'algorithm' must not be null.", new NullPointerException("'algorithm'"));

        byte[] retVal = getHashNative(getHandle(), algorithm.getValue());

        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return retVal;
    }




    private native byte[] getHashNative(long handle, int algorithm);

}

