/****************************************************************************
 *
 * File:            SignatureRemoval.java
 *
 * Description:     SignatureRemoval Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.sign;

/**
 * 
 */
public enum SignatureRemoval  
{
    /**
     * 
     * Do not remove any signatures.
     */
    NONE(1),
    /**
     * 
     * <p>
     * Remove all signed signatures, but no unsigned signature fields.
     * This lets you change the encryption parameters of signed input documents, e.g. to encrypt or decrypt them (see {@link WarningCategory#SIGNED_DOC_ENCRYPTION_UNCHANGED }).</p>
     * <p>
     * While the cryptographic parts of the signatures are removed, their visual appearances are preserved.
     * </p>
     */
    SIGNED(2),
    /**
     * 
     * Remove all signed (see {@link SignatureRemoval#SIGNED }) and unsigned signature fields.
     */
    ALL(3);

    SignatureRemoval(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static SignatureRemoval fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return NONE;
            case 2: return SIGNED;
            case 3: return ALL;
        }
        throw new IllegalArgumentException("Unknown value for SignatureRemoval: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
