/****************************************************************************
 *
 * File:            CmsSignatureContent.java
 *
 * Description:     PDFTOOLS CmsSignatureContent Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The data and validation result of the cryptographic signature</h1>
 */
public class CmsSignatureContent extends com.pdftools.signaturevalidation.SignatureContent 
{
    protected CmsSignatureContent(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static CmsSignatureContent createDynamicObject(long handle)
    {
        return new CmsSignatureContent(handle);
    }




     /**
     * <h1>The time at which the signature has been validated (Getter)</h1>
     * 
     */
    public OffsetDateTime getValidationTime()
    {
        OffsetDateTime retVal = getValidationTimeNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * <h1>The source for the validation time (Getter)</h1>
     * 
     */
    public EnumSet<com.pdftools.signaturevalidation.TimeSource> getValidationTimeSource()
    {
        int retVal = getValidationTimeSourceNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return getEnumSet(retVal, com.pdftools.signaturevalidation.TimeSource.class);
    }


     /**
     * <h1>The hash algorithm used to calculate the signature's message digest (Getter)</h1>
     * 
     */
    public com.pdftools.crypto.HashAlgorithm getHashAlgorithm()
    {
        int retVal = getHashAlgorithmNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.crypto.HashAlgorithm.fromValue(retVal);
    }


     /**
     * <h1>The data and validation result of the embedded time-stamp (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.TimeStampContent getTimeStamp()
    {
        long retHandle = getTimeStampNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
            return null;
        }
        return com.pdftools.signaturevalidation.TimeStampContent.createDynamicObject(retHandle);

    }


     /**
     * <h1>The signing certificate (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.Certificate getSigningCertificate()
    {
        long retHandle = getSigningCertificateNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
            return null;
        }
        return com.pdftools.signaturevalidation.Certificate.createDynamicObject(retHandle);

    }


     /**
     * <h1>The certificate chain of the signing certificate (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.CertificateChain getCertificateChain()
    {
        long retHandle = getCertificateChainNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
            return null;
        }
        return com.pdftools.signaturevalidation.CertificateChain.createDynamicObject(retHandle);

    }




    private native OffsetDateTime getValidationTimeNative(long handle);
    private native int getValidationTimeSourceNative(long handle);
    private native int getHashAlgorithmNative(long handle);
    private native long getTimeStampNative(long handle);
    private native long getSigningCertificateNative(long handle);
    private native long getCertificateChainNative(long handle);

}

