/****************************************************************************
 *
 * File:            ConstraintResult.java
 *
 * Description:     PDFTOOLS ConstraintResult Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The result of a constraint validation.</h1>
 */
public class ConstraintResult extends NativeObject 
{
    protected ConstraintResult(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ConstraintResult createDynamicObject(long handle)
    {
        return new ConstraintResult(handle);
    }




     /**
     * <h1>The validation message (Getter)</h1>
     * 
     */
    public String getMessage()
    {
        String retVal = getMessageNative(getHandle());
        if (retVal == null)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return retVal;
    }


     /**
     * <h1>The main indication (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.Indication getIndication()
    {
        int retVal = getIndicationNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.Indication.fromValue(retVal);
    }


     /**
     * <h1>The sub indication (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.SubIndication getSubIndication()
    {
        int retVal = getSubIndicationNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.SubIndication.fromValue(retVal);
    }




    private native String getMessageNative(long handle);
    private native int getIndicationNative(long handle);
    private native int getSubIndicationNative(long handle);

}

