/****************************************************************************
 *
 * File:            Indication.java
 *
 * Description:     Indication Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

/**
 * <h1>Main status indication of the signature validation process</h1>
 * See ETSI TS 102 853 and ETSI EN 319 102-1.
 */
public enum Indication  
{
    /**
     * <h1>The constraint is valid according to the chosen signature validation profile.</h1>
     */
    VALID(1),
    /**
     * <h1>The constraint is invalid according to the chosen signature validation profile.</h1>
     */
    INVALID(2),
    /**
     * <h1>The available information is insufficient to determine whether the signature is valid or invalid.</h1>
     */
    INDETERMINATE(3);

    Indication(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static Indication fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return VALID;
            case 2: return INVALID;
            case 3: return INDETERMINATE;
        }
        throw new IllegalArgumentException("Unknown value for Indication: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
