/****************************************************************************
 *
 * File:            SignatureContent.java
 *
 * Description:     PDFTOOLS SignatureContent Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The data and validation result of the cryptographic signature</h1>
 */
public abstract class SignatureContent extends NativeObject 
{
    protected SignatureContent(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static SignatureContent createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.signaturevalidation.UnsupportedSignatureContent.createDynamicObject(handle);
            case 2:
                return com.pdftools.signaturevalidation.CmsSignatureContent.createDynamicObject(handle);
            case 3:
                return com.pdftools.signaturevalidation.TimeStampContent.createDynamicObject(handle);
            default:
                return null;
        }
    }




     /**
     * <h1>Whether the cryptographic signature is valid according to the validation profile used (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.ConstraintResult getValidity()
    {
        long retHandle = getValidityNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.ConstraintResult.createDynamicObject(retHandle);

    }




    private static native int getType(long handle);
    private native long getValidityNative(long handle);

}

