/****************************************************************************
 *
 * File:            SignatureSelector.java
 *
 * Description:     SignatureSelector Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

/**
 * <h1>Select the signatures</h1>
 */
public enum SignatureSelector  
{
    /**
     * <h1>Select the latest signature.</h1>
     */
    LATEST(1),
    /**
     * <h1>Select all signatures.</h1>
     */
    ALL(2);

    SignatureSelector(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static SignatureSelector fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return LATEST;
            case 2: return ALL;
        }
        throw new IllegalArgumentException("Unknown value for SignatureSelector: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
