/****************************************************************************
 *
 * File:            TimeSource.java
 *
 * Description:     TimeSource Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

import com.pdftools.internal.Flag;

/**
 * <h1>The source of the validation time</h1>
 */
public enum TimeSource implements Flag 
{
    /**
     * <h1>Proof of Existence</h1>
     * A proof of existence is evidence that proves that an object (a certificate, a CRL, signature value, hash value, etc.) existed at a specific time, which may be a time in the past.
     * The presence of a given object at the current time is a proof of its existence at the current time.
     * A suitable way of providing proof of existence of an object at a time in the past is to generate a time-stamp for that object.
     */
    PROOF_OF_EXISTENCE(0x0001),
    /**
     * <h1>Expired time stamp</h1>
     * An expired time-stamp was used.
     * Note that for expired time-stamps revocation information checks might not be possible.
     */
    EXPIRED_TIME_STAMP(0x0002),
    /**
     * <h1>Signature time</h1>
     * Use the claimed (untrusted) time of the signature.
     */
    SIGNATURE_TIME(0x0004);

    TimeSource(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public int getFlag() 
    {
        return value;
    }

    private int value;
}
