/****************************************************************************
 *
 * File:            UnsupportedSignatureContent.java
 *
 * Description:     PDFTOOLS UnsupportedSignatureContent Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The validation result of a signature that cannot be read either because it has an unsupported type or is corrupt</h1>
 */
public class UnsupportedSignatureContent extends com.pdftools.signaturevalidation.SignatureContent 
{
    protected UnsupportedSignatureContent(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static UnsupportedSignatureContent createDynamicObject(long handle)
    {
        return new UnsupportedSignatureContent(handle);
    }





}

