/****************************************************************************
 *
 * File:            ValidationResult.java
 *
 * Description:     PDFTOOLS ValidationResult Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The result of a signature validation</h1>
 */
public class ValidationResult extends NativeObject 
{
    protected ValidationResult(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ValidationResult createDynamicObject(long handle)
    {
        return new ValidationResult(handle);
    }




     /**
     * <h1>The signature field (Getter)</h1>
     * 
     */
    public com.pdftools.pdf.SignedSignatureField getSignatureField()
    {
        long retHandle = getSignatureFieldNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.pdf.SignedSignatureField.createDynamicObject(retHandle);

    }


     /**
     * <h1>The data and validation result of the cryptographic signature (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.SignatureContent getSignatureContent()
    {
        long retHandle = getSignatureContentNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.SignatureContent.createDynamicObject(retHandle);

    }




    private native long getSignatureFieldNative(long handle);
    private native long getSignatureContentNative(long handle);

}

