/****************************************************************************
 *
 * File:            Default.java
 *
 * Description:     PDFTOOLS Default Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The default signature validation profile</h1>
 * <p>
 * This profile is suitable for general signature validation.
 * It is not very strict.</p>
 * <p>
 * The default values are:
 * <ul>
 * <li>
 * {@link Profile#getValidationOptions }:
 * <ul>
 * <li>
 * {@link ValidationOptions#getTimeSource }: {@link com.pdftools.signaturevalidation.TimeSource#PROOF_OF_EXISTENCE pdftools.signaturevalidation.TimeSource.PROOF_OF_EXISTENCE} + {@link com.pdftools.signaturevalidation.TimeSource#EXPIRED_TIME_STAMP pdftools.signaturevalidation.TimeSource.EXPIRED_TIME_STAMP}</li>
 * <li>
 * {@link ValidationOptions#getCertificateSources }: all</li>
 * <li>
 * {@link ValidationOptions#getRevocationInformationSources }: all</li>
 * </ul></li>
 * <li>
 * {@link Profile#getSigningCertTrustConstraints }:
 * <ul>
 * <li>
 * {@link TrustConstraints#getTrustSources }: {@link com.pdftools.signaturevalidation.DataSource#AATL pdftools.signaturevalidation.DataSource.AATL} + {@link com.pdftools.signaturevalidation.DataSource#EUTL pdftools.signaturevalidation.DataSource.EUTL} + {@link com.pdftools.signaturevalidation.DataSource#CUSTOM_TRUST_LIST pdftools.signaturevalidation.DataSource.CUSTOM_TRUST_LIST}</li>
 * <li>
 * {@link TrustConstraints#getRevocationCheckPolicy }: {@link RevocationCheckPolicy#OPTIONAL }</li>
 * </ul></li>
 * <li>
 * {@link Profile#getTimeStampTrustConstraints }:
 * <ul>
 * <li>
 * {@link TrustConstraints#getTrustSources }: {@link com.pdftools.signaturevalidation.DataSource#AATL pdftools.signaturevalidation.DataSource.AATL} + {@link com.pdftools.signaturevalidation.DataSource#EUTL pdftools.signaturevalidation.DataSource.EUTL} + {@link com.pdftools.signaturevalidation.DataSource#CUSTOM_TRUST_LIST pdftools.signaturevalidation.DataSource.CUSTOM_TRUST_LIST}</li>
 * <li>
 * {@link TrustConstraints#getRevocationCheckPolicy }: {@link RevocationCheckPolicy#OPTIONAL }</li>
 * </ul></li>
 * </ul></p>
 */
public class Default extends com.pdftools.signaturevalidation.profiles.Profile 
{
    protected Default(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Default createDynamicObject(long handle)
    {
        return new Default(handle);
    }


    /**
     * 
     */
    public Default()
    {
        this(newHelper());
    }

    private static long newHelper()
    {
        long handle = newNative();
        if (handle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }

        return handle;
    }




    private static native long newNative();
}

