/****************************************************************************
 *
 * File:            Profile.java
 *
 * Description:     PDFTOOLS Profile Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>The base class for signature validation profiles</h1>
 * The profile defines the validation constraints.
 */
public abstract class Profile extends NativeObject 
{
    protected Profile(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static Profile createDynamicObject(long handle)
    {
        int type = getType(handle);
        switch (type)
        {
            case 1:
                return com.pdftools.signaturevalidation.profiles.Default.createDynamicObject(handle);
            default:
                return null;
        }
    }




     /**
     * <h1>Signature validation options (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.profiles.ValidationOptions getValidationOptions()
    {
        long retHandle = getValidationOptionsNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.profiles.ValidationOptions.createDynamicObject(retHandle);

    }


     /**
     * <h1>Trust constraints for certificates of signatures (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.profiles.TrustConstraints getSigningCertTrustConstraints()
    {
        long retHandle = getSigningCertTrustConstraintsNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.profiles.TrustConstraints.createDynamicObject(retHandle);

    }


     /**
     * <h1>Trust constraints for certificates of time-stamps (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.profiles.TrustConstraints getTimeStampTrustConstraints()
    {
        long retHandle = getTimeStampTrustConstraintsNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.profiles.TrustConstraints.createDynamicObject(retHandle);

    }


     /**
     * <h1>The custom list of trusted certificates (Getter)</h1>
     * Default: {@code null} (no custom trust list)
     */
    public com.pdftools.signaturevalidation.CustomTrustList getCustomTrustList()
    {
        long retHandle = getCustomTrustListNative(getHandle());
        if (retHandle == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
            return null;
        }
        return com.pdftools.signaturevalidation.CustomTrustList.createDynamicObject(retHandle);

    }

     /**
     * <h1>The custom list of trusted certificates (Setter)</h1>
     * Default: {@code null} (no custom trust list)
     */
    public void setCustomTrustList(com.pdftools.signaturevalidation.CustomTrustList value)
    {
        boolean retVal = setCustomTrustListNative(getHandle(), getHandle(value), value);
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private static native int getType(long handle);
    private native long getValidationOptionsNative(long handle);
    private native long getSigningCertTrustConstraintsNative(long handle);
    private native long getTimeStampTrustConstraintsNative(long handle);
    private native long getCustomTrustListNative(long handle);
    private native boolean setCustomTrustListNative(long handle, long value, com.pdftools.signaturevalidation.CustomTrustList valueObj);

}

