/****************************************************************************
 *
 * File:            RevocationCheckPolicy.java
 *
 * Description:     RevocationCheckPolicy Enumeration
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation.profiles;

/**
 * <h1>The revocation check policy</h1>
 */
public enum RevocationCheckPolicy  
{
    /**
     * 
     * <ul>
     * <li>
     * Certificate must have revocation information (OCSP or CRL)</li>
     * <li>
     * Revocation information is acquired from revocation sources</li>
     * <li>
     * Revocation information is validated</li>
     * </ul>
     */
    REQUIRED(1),
    /**
     * 
     * Same as {@code Required} for certificates that have revocation information and {@code NoCheck} otherwise.
     */
    SUPPORTED(2),
    /**
     * 
     * Same as {@code Supported} if revocation information is available in the {@code RevocationInformationSources} and {@code NoCheck} otherwise.
     */
    OPTIONAL(3),
    /**
     * <h1>Do not check revocation information.</h1>
     */
    NO_CHECK(4);

    RevocationCheckPolicy(int value) 
    {
        this.value = value;
    }

    /**
     * @hidden
     */
    public static RevocationCheckPolicy fromValue(int value) 
    {
        switch (value) 
        {
            case 1: return REQUIRED;
            case 2: return SUPPORTED;
            case 3: return OPTIONAL;
            case 4: return NO_CHECK;
        }
        throw new IllegalArgumentException("Unknown value for RevocationCheckPolicy: " + value);
    }

    /**
     * @hidden
     */
    public int getValue() 
    {
        return value;
    }

    private int value;
}
