/****************************************************************************
 *
 * File:            TrustConstraints.java
 *
 * Description:     PDFTOOLS TrustConstraints Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>Certificate trust constraints</h1>
 */
public class TrustConstraints extends NativeObject 
{
    protected TrustConstraints(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static TrustConstraints createDynamicObject(long handle)
    {
        return new TrustConstraints(handle);
    }




     /**
     * <h1>Allowed sources for trusted certificates (Getter)</h1>
     * Note that the trust sources are implicitly added to the profile's {@link ValidationOptions#getCertificateSources }.
     */
    public EnumSet<com.pdftools.signaturevalidation.DataSource> getTrustSources()
    {
        int retVal = getTrustSourcesNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return getEnumSet(retVal, com.pdftools.signaturevalidation.DataSource.class);
    }

     /**
     * <h1>Allowed sources for trusted certificates (Setter)</h1>
     * Note that the trust sources are implicitly added to the profile's {@link ValidationOptions#getCertificateSources }.
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setTrustSources(EnumSet<com.pdftools.signaturevalidation.DataSource> value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setTrustSourcesNative(getHandle(), getFlags(value));
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }


     /**
     * <h1>Whether to check certificate revocation (Getter)</h1>
     * 
     */
    public com.pdftools.signaturevalidation.profiles.RevocationCheckPolicy getRevocationCheckPolicy()
    {
        int retVal = getRevocationCheckPolicyNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return com.pdftools.signaturevalidation.profiles.RevocationCheckPolicy.fromValue(retVal);
    }

     /**
     * <h1>Whether to check certificate revocation (Setter)</h1>
     * 
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setRevocationCheckPolicy(com.pdftools.signaturevalidation.profiles.RevocationCheckPolicy value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setRevocationCheckPolicyNative(getHandle(), value.getValue());
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private native int getTrustSourcesNative(long handle);
    private native boolean setTrustSourcesNative(long handle, int value);
    private native int getRevocationCheckPolicyNative(long handle);
    private native boolean setRevocationCheckPolicyNative(long handle, int value);

}

