/****************************************************************************
 *
 * File:            ValidationOptions.java
 *
 * Description:     PDFTOOLS ValidationOptions Class
 *
 * Author:          PDF Tools AG
 * 
 * Copyright:       Copyright (C) 2023 - 2025 PDF Tools AG, Switzerland
 *                  All rights reserved.
 * 
 * Notice:          By downloading and using this artifact, you accept PDF Tools AG's
 *                  [license agreement](https://www.pdf-tools.com/license-agreement/),
 *                  [privacy policy](https://www.pdf-tools.com/privacy-policy/),
 *                  and allow PDF Tools AG to track your usage data.
 *
 ***************************************************************************/

package com.pdftools.signaturevalidation.profiles;

import com.pdftools.sys.*;
import com.pdftools.internal.*;
import java.util.EnumSet;
import java.time.OffsetDateTime;
/**
 * <h1>Signature validation options</h1>
 */
public class ValidationOptions extends NativeObject 
{
    protected ValidationOptions(long handle) 
    {
        super(handle);
    }

    /**
     * @hidden
     */
    public static ValidationOptions createDynamicObject(long handle)
    {
        return new ValidationOptions(handle);
    }




     /**
     * <h1>Allowed validation time sources (Getter)</h1>
     * 
     */
    public EnumSet<com.pdftools.signaturevalidation.TimeSource> getTimeSource()
    {
        int retVal = getTimeSourceNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return getEnumSet(retVal, com.pdftools.signaturevalidation.TimeSource.class);
    }

     /**
     * <h1>Allowed validation time sources (Setter)</h1>
     * 
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setTimeSource(EnumSet<com.pdftools.signaturevalidation.TimeSource> value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setTimeSourceNative(getHandle(), getFlags(value));
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }


     /**
     * <h1>Allowed sources to get certificates, e.g. intermediate issuer certificates (Getter)</h1>
     * 
     */
    public EnumSet<com.pdftools.signaturevalidation.DataSource> getCertificateSources()
    {
        int retVal = getCertificateSourcesNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return getEnumSet(retVal, com.pdftools.signaturevalidation.DataSource.class);
    }

     /**
     * <h1>Allowed sources to get certificates, e.g. intermediate issuer certificates (Setter)</h1>
     * 
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setCertificateSources(EnumSet<com.pdftools.signaturevalidation.DataSource> value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setCertificateSourcesNative(getHandle(), getFlags(value));
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }


     /**
     * <h1>Allowed sources to get revocation information (OCSP, CRL) (Getter)</h1>
     * 
     */
    public EnumSet<com.pdftools.signaturevalidation.DataSource> getRevocationInformationSources()
    {
        int retVal = getRevocationInformationSourcesNative(getHandle());
        if (retVal == 0)
        {
            switch (getLastErrorCode())
            {
                case 0: break;
                default: throwLastRuntimeException();
            }
        }
        return getEnumSet(retVal, com.pdftools.signaturevalidation.DataSource.class);
    }

     /**
     * <h1>Allowed sources to get revocation information (OCSP, CRL) (Setter)</h1>
     * 
     * @throws IllegalArgumentException if {@code value} is {@code null}
     */
    public void setRevocationInformationSources(EnumSet<com.pdftools.signaturevalidation.DataSource> value)
    {
        if (value == null)
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        boolean retVal = setRevocationInformationSourcesNative(getHandle(), getFlags(value));
        if (!retVal) 
        {
            switch (getLastErrorCode())
            {
                case 0: throw new RuntimeException("An unexpected error occurred");
                default: throwLastRuntimeException();
            }
        }
    }




    private native int getTimeSourceNative(long handle);
    private native boolean setTimeSourceNative(long handle, int value);
    private native int getCertificateSourcesNative(long handle);
    private native boolean setCertificateSourcesNative(long handle, int value);
    private native int getRevocationInformationSourcesNative(long handle);
    private native boolean setRevocationInformationSourcesNative(long handle, int value);

}

