package com.pdftools.sys;

/**
 * The unified stream interface for reading and writing data.
 *
 * Java's stream interfaces cannot be used, because they are lacking two important features:
 * <ul>
 * <li>
 * The PDF file format is based on random access. Java streams have only limited support for this.
 * </li>
 * <li>
 * The ability to read from an output stream is crucial for processing large PDF files.
 * </li>
 * </ul>
 */
public interface Stream extends AutoCloseable
{
    /**
     * Get the length of the stream in bytes
     * @return the length of the stream  in bytes
     */
    long getLength() throws java.io.IOException;

    /**
     * Set byte position
     * @param position The new position of the stream (-1 for EOS)
     * @return true if successful
     */
    boolean seek(long position) throws java.io.IOException;

    /**
     * Get current byte position
     * @return byte position, -1 if position unknown
     */
    long tell() throws java.io.IOException;

    /**
     * Read from the stream
     * @param buffer The buffer where the data is written
     * @param offset The starting element in the buffer
     * @param length The maximum number of bytes to be read
     * @return The actual number of bytes read (-1 if EOS)
     */
    int read(byte[] buffer, int offset, int length) throws java.io.IOException;

    /**
     * Write to the stream
     * @param buffer The buffer where the data lies
     * @param offset The starting element in the buffer
     * @param length The maximum number of bytes to write
     */
    void write(byte[] buffer, int offset, int length) throws java.io.IOException;

    /**
     * Close the stream and release all associated resources.
     */
    public void close() throws java.io.IOException;
}
