/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools;

import com.pdftools.CorruptException;
import com.pdftools.PasswordException;
import com.pdftools.internal.NativeObject;
import com.pdftools.sys.Stream;

public class HttpClientHandler
extends NativeObject {
    protected HttpClientHandler(long handle) {
        super(handle);
    }

    public static HttpClientHandler createDynamicObject(long handle) {
        return new HttpClientHandler(handle);
    }

    public HttpClientHandler() {
        this(HttpClientHandler.newHelper());
    }

    private static long newHelper() {
        long handle = HttpClientHandler.newNative();
        if (handle == 0L) {
            switch (HttpClientHandler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            HttpClientHandler.throwLastRuntimeException();
        }
        return handle;
    }

    public void setClientCertificate(Stream archive, String password) throws CorruptException, PasswordException {
        if (archive == null) {
            throw new IllegalArgumentException("Argument 'archive' must not be null.", new NullPointerException("'archive'"));
        }
        boolean retVal = this.setClientCertificateNative(this.getHandle(), archive, password);
        if (!retVal) {
            switch (HttpClientHandler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(HttpClientHandler.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(HttpClientHandler.getLastErrorMessage());
                }
                case 17: {
                    throw new PasswordException(HttpClientHandler.getLastErrorMessage());
                }
            }
            HttpClientHandler.throwLastRuntimeException();
        }
    }

    public void setClientCertificateAndKey(Stream cert, Stream key, String password) throws CorruptException, PasswordException {
        if (cert == null) {
            throw new IllegalArgumentException("Argument 'cert' must not be null.", new NullPointerException("'cert'"));
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' must not be null.", new NullPointerException("'key'"));
        }
        boolean retVal = this.setClientCertificateAndKeyNative(this.getHandle(), cert, key, password);
        if (!retVal) {
            switch (HttpClientHandler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 16: {
                    throw new CorruptException(HttpClientHandler.getLastErrorMessage());
                }
                case 17: {
                    throw new PasswordException(HttpClientHandler.getLastErrorMessage());
                }
            }
            HttpClientHandler.throwLastRuntimeException();
        }
    }

    public void addTrustedCertificate(Stream cert) throws CorruptException {
        if (cert == null) {
            throw new IllegalArgumentException("Argument 'cert' must not be null.", new NullPointerException("'cert'"));
        }
        boolean retVal = this.addTrustedCertificateNative(this.getHandle(), cert);
        if (!retVal) {
            switch (HttpClientHandler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 16: {
                    throw new CorruptException(HttpClientHandler.getLastErrorMessage());
                }
            }
            HttpClientHandler.throwLastRuntimeException();
        }
    }

    public boolean getSslVerifyServerCertificate() {
        boolean retVal = this.getSslVerifyServerCertificateNative(this.getHandle());
        if (!retVal) {
            switch (HttpClientHandler.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    HttpClientHandler.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setSslVerifyServerCertificate(boolean value) {
        boolean retVal = this.setSslVerifyServerCertificateNative(this.getHandle(), value);
        if (!retVal) {
            switch (HttpClientHandler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            HttpClientHandler.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native boolean setClientCertificateNative(long var1, Stream var3, String var4);

    private native boolean setClientCertificateAndKeyNative(long var1, Stream var3, Stream var4, String var5);

    private native boolean addTrustedCertificateNative(long var1, Stream var3);

    private native boolean getSslVerifyServerCertificateNative(long var1);

    private native boolean setSslVerifyServerCertificateNative(long var1, boolean var3);
}

