/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class IndexedIterator<E>
implements ListIterator<E> {
    List<E> list;
    int index;
    int lastIndex;

    IndexedIterator(List<E> list, int index) {
        this.list = list;
        this.index = index;
        this.lastIndex = -1;
    }

    @Override
    public void add(E e) {
        this.list.add(this.index++, e);
        this.lastIndex = -1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public boolean hasPrevious() {
        return this.index > 0;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastIndex = this.index++;
        return this.list.get(this.lastIndex);
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public E previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastIndex = --this.index;
        return this.list.get(this.lastIndex);
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public void remove() {
        if (this.lastIndex < 0) {
            throw new IllegalStateException();
        }
        this.list.remove(this.lastIndex);
        this.index = this.lastIndex;
        this.lastIndex = -1;
    }

    @Override
    public void set(E e) {
        if (this.lastIndex < 0 || this.lastIndex >= this.list.size()) {
            throw new IllegalStateException();
        }
        this.list.set(this.lastIndex, e);
    }
}

