/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools;

import com.pdftools.CorruptException;
import com.pdftools.HttpClientHandler;
import com.pdftools.HttpException;
import com.pdftools.LicenseException;
import com.pdftools.LicenseInfo;
import com.pdftools.NotFoundException;
import com.pdftools.UnknownFormatException;
import com.pdftools.internal.NativeObject;
import java.net.URI;

public class Sdk
extends NativeObject {
    protected Sdk(long handle) {
        super(handle);
    }

    public static Sdk createDynamicObject(long handle) {
        return new Sdk(handle);
    }

    public static void initialize(String license) throws LicenseException, UnknownFormatException, CorruptException, HttpException {
        if (license == null) {
            throw new IllegalArgumentException("Argument 'license' must not be null.", new NullPointerException("'license'"));
        }
        Sdk.initialize(license, null);
    }

    public static void initialize(String license, String producerSuffix) throws LicenseException, UnknownFormatException, CorruptException, HttpException {
        if (license == null) {
            throw new IllegalArgumentException("Argument 'license' must not be null.", new NullPointerException("'license'"));
        }
        boolean retVal = Sdk.initializeNative(license, producerSuffix);
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 12: {
                    throw new LicenseException(Sdk.getLastErrorMessage());
                }
                case 15: {
                    throw new UnknownFormatException(Sdk.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Sdk.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Sdk.getLastErrorMessage());
                }
            }
            Sdk.throwLastRuntimeException();
        }
    }

    public static void addFontDirectory(String directory) throws NotFoundException {
        if (directory == null) {
            throw new IllegalArgumentException("Argument 'directory' must not be null.", new NullPointerException("'directory'"));
        }
        boolean retVal = Sdk.addFontDirectoryNative(directory);
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 5: {
                    throw new NotFoundException(Sdk.getLastErrorMessage());
                }
            }
            Sdk.throwLastRuntimeException();
        }
    }

    public static String getVersion() {
        String retVal = Sdk.getVersionNative();
        if (retVal == null) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
        return retVal;
    }

    public static void setProducerSuffix(String value) {
        boolean retVal = Sdk.setProducerSuffixNative(value);
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
    }

    public static String getProducerFullName() {
        String retVal = Sdk.getProducerFullNameNative();
        if (retVal == null) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
        return retVal;
    }

    public static URI getProxy() {
        String retVal = Sdk.getProxyNative();
        if (retVal == null) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Sdk.throwLastRuntimeException();
                }
            }
            return null;
        }
        return URI.create(retVal);
    }

    public static void setProxy(URI value) {
        boolean retVal = Sdk.setProxyNative(value != null ? value.toString() : null);
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
    }

    public static HttpClientHandler getHttpClientHandler() {
        long retHandle = Sdk.getHttpClientHandlerNative();
        if (retHandle == 0L) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
        return HttpClientHandler.createDynamicObject(retHandle);
    }

    public static boolean getUsageTracking() {
        boolean retVal = Sdk.getUsageTrackingNative();
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Sdk.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public static void setUsageTracking(boolean value) {
        boolean retVal = Sdk.setUsageTrackingNative(value);
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
    }

    public static URI getLicensingService() {
        String retVal = Sdk.getLicensingServiceNative();
        if (retVal == null) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
        return URI.create(retVal);
    }

    public static void setLicensingService(URI value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = Sdk.setLicensingServiceNative(value.toString());
        if (!retVal) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Sdk.getLastErrorMessage());
                }
            }
            Sdk.throwLastRuntimeException();
        }
    }

    public static LicenseInfo getLicenseInfoSnapshot() {
        long retHandle = Sdk.getLicenseInfoSnapshotNative();
        if (retHandle == 0L) {
            switch (Sdk.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Sdk.throwLastRuntimeException();
        }
        return LicenseInfo.createDynamicObject(retHandle);
    }

    private static native boolean initializeNative(String var0, String var1);

    private static native boolean addFontDirectoryNative(String var0);

    private static native String getVersionNative();

    private static native boolean setProducerSuffixNative(String var0);

    private static native String getProducerFullNameNative();

    private static native String getProxyNative();

    private static native boolean setProxyNative(String var0);

    private static native long getHttpClientHandlerNative();

    private static native boolean getUsageTrackingNative();

    private static native boolean setUsageTrackingNative(boolean var0);

    private static native String getLicensingServiceNative();

    private static native boolean setLicensingServiceNative(String var0);

    private static native long getLicenseInfoSnapshotNative();
}

