/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools;

import com.pdftools.IndexedIterator;
import com.pdftools.SubList;
import com.pdftools.internal.NativeObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StringList
extends NativeObject
implements List<String> {
    protected StringList(long handle) {
        super(handle);
    }

    public static StringList createDynamicObject(long handle) {
        return new StringList(handle);
    }

    public StringList() {
        this(StringList.newHelper());
    }

    private static long newHelper() {
        long handle = StringList.newNative();
        if (handle == 0L) {
            switch (StringList.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StringList.throwLastRuntimeException();
        }
        return handle;
    }

    private static native long newNative();

    @Override
    public boolean addAll(Collection<? extends String> elements) {
        if (elements == null) {
            throw new NullPointerException("'elements'");
        }
        if (elements.isEmpty()) {
            return false;
        }
        for (String string : elements) {
            this.add(string);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> elements) {
        if (elements == null) {
            throw new NullPointerException("'elements'");
        }
        if (elements.isEmpty()) {
            return false;
        }
        for (String string : elements) {
            this.add(index++, string);
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException("'object'");
        }
        for (String element : this) {
            if (!element.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object element : objects) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<String> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return new IndexedIterator<String>(this, index);
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException("'object'");
        }
        int index = this.indexOf(object);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (objects == null) {
            throw new NullPointerException("'objects'");
        }
        boolean changed = false;
        for (Object object : objects) {
            changed = this.remove(object) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (objects == null) {
            throw new NullPointerException("'objects'");
        }
        boolean changed = false;
        Iterator<String> it = this.iterator();
        while (it.hasNext()) {
            if (objects.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        return new SubList<String>(this, fromIndex, toIndex - fromIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int index = 0; index < this.size(); ++index) {
            array[index] = this.get(index);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        } else if (array.length > size) {
            array[size] = null;
        }
        int i = 0;
        for (String e : this) {
            array[i] = e;
            ++i;
        }
        return array;
    }

    @Override
    public int size() {
        int n = this.sizeNative(this.getHandle());
        if (n == -1) {
            StringList.throwLastRuntimeException(false);
        }
        return n;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Method 'clear' is not supported by this class.");
    }

    @Override
    public int indexOf(Object obj) {
        if (obj == null) {
            throw new NullPointerException("'obj'");
        }
        for (int index = 0; index < this.size(); ++index) {
            if (!obj.equals(this.get(index))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj == null) {
            throw new NullPointerException("'obj'");
        }
        for (int index = this.size() - 1; index >= 0; --index) {
            if (!obj.equals(this.get(index))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public void add(int index, String element) {
        if (element == null) {
            throw new NullPointerException("'element'");
        }
        if (!this.insertNative(this.getHandle(), index, element)) {
            StringList.throwLastRuntimeException(false);
        }
    }

    @Override
    public boolean add(String element) {
        if (element == null) {
            throw new NullPointerException("'element'");
        }
        if (!this.addNative(this.getHandle(), element)) {
            StringList.throwLastRuntimeException(false);
        }
        return true;
    }

    @Override
    public String get(int index) {
        String retVal = this.getNative(this.getHandle(), index);
        if (retVal == null) {
            StringList.throwLastRuntimeException(false);
        }
        return retVal;
    }

    @Override
    public String remove(int index) {
        throw new UnsupportedOperationException("Method 'remove' is not supported by this class.");
    }

    @Override
    public String set(int index, String element) {
        throw new UnsupportedOperationException("Method 'set' is not supported by this class.");
    }

    private native int sizeNative(long var1);

    private native String getNative(long var1, int var3);

    private native boolean addNative(long var1, String var3);

    private native boolean insertNative(long var1, int var3, String var4);
}

