/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto;

public enum HashAlgorithm {
    MD5(1),
    RIPE_MD160(2),
    SHA1(3),
    SHA256(4),
    SHA384(5),
    SHA512(6),
    SHA3_256(7),
    SHA3_384(8),
    SHA3_512(9);

    private int value;

    private HashAlgorithm(int value) {
        this.value = value;
    }

    public static HashAlgorithm fromValue(int value) {
        switch (value) {
            case 1: {
                return MD5;
            }
            case 2: {
                return RIPE_MD160;
            }
            case 3: {
                return SHA1;
            }
            case 4: {
                return SHA256;
            }
            case 5: {
                return SHA384;
            }
            case 6: {
                return SHA512;
            }
            case 7: {
                return SHA3_256;
            }
            case 8: {
                return SHA3_384;
            }
            case 9: {
                return SHA3_512;
            }
        }
        throw new IllegalArgumentException("Unknown value for HashAlgorithm: " + value);
    }

    public int getValue() {
        return this.value;
    }
}

