/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto;

public enum SignatureAlgorithm {
    RSA_RSA(1),
    RSA_SSA_PSS(2),
    ECDSA(3);

    private int value;

    private SignatureAlgorithm(int value) {
        this.value = value;
    }

    public static SignatureAlgorithm fromValue(int value) {
        switch (value) {
            case 1: {
                return RSA_RSA;
            }
            case 2: {
                return RSA_SSA_PSS;
            }
            case 3: {
                return ECDSA;
            }
        }
        throw new IllegalArgumentException("Unknown value for SignatureAlgorithm: " + value);
    }

    public int getValue() {
        return this.value;
    }
}

