/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers;

import com.pdftools.internal.NativeObject;

public class Certificate
extends NativeObject {
    protected Certificate(long handle) {
        super(handle);
    }

    public static Certificate createDynamicObject(long handle) {
        return new Certificate(handle);
    }

    public String getName() {
        String retVal = this.getNameNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getSubject() {
        String retVal = this.getSubjectNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Certificate.throwLastRuntimeException();
        }
        return retVal;
    }

    public String getIssuer() {
        String retVal = this.getIssuerNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getFingerprint() {
        String retVal = this.getFingerprintNative(this.getHandle());
        if (retVal == null) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public boolean getHasPrivateKey() {
        boolean retVal = this.getHasPrivateKeyNative(this.getHandle());
        if (!retVal) {
            switch (Certificate.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Certificate.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    private native String getNameNative(long var1);

    private native String getSubjectNative(long var1);

    private native String getIssuerNative(long var1);

    private native String getFingerprintNative(long var1);

    private native boolean getHasPrivateKeyNative(long var1);
}

