/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.builtin;

import com.pdftools.CorruptException;
import com.pdftools.PasswordException;
import com.pdftools.crypto.providers.builtin.SignatureConfiguration;
import com.pdftools.crypto.providers.builtin.TimestampConfiguration;
import com.pdftools.sys.Stream;
import java.net.URI;

public class Provider
extends com.pdftools.crypto.providers.Provider {
    protected Provider(long handle) {
        super(handle);
    }

    public static Provider createDynamicObject(long handle) {
        return new Provider(handle);
    }

    public Provider() {
        this(Provider.newHelper());
    }

    private static long newHelper() {
        long handle = Provider.newNative();
        if (handle == 0L) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Provider.throwLastRuntimeException();
        }
        return handle;
    }

    public SignatureConfiguration createSignatureFromCertificate(Stream stream, String password) throws CorruptException, PasswordException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = this.createSignatureFromCertificateNative(this.getHandle(), stream, password);
        if (retHandle == 0L) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Provider.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Provider.getLastErrorMessage());
                }
                case 17: {
                    throw new PasswordException(Provider.getLastErrorMessage());
                }
            }
            Provider.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public TimestampConfiguration createTimestamp() {
        long retHandle = this.createTimestampNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Provider.throwLastRuntimeException();
        }
        return TimestampConfiguration.createDynamicObject(retHandle);
    }

    public com.pdftools.sign.SignatureConfiguration createPreparedSignature(int size, String format, String name) {
        if (format == null) {
            throw new IllegalArgumentException("Argument 'format' must not be null.", new NullPointerException("'format'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        long retHandle = this.createPreparedSignatureNative(this.getHandle(), size, format, name);
        if (retHandle == 0L) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Provider.throwLastRuntimeException();
        }
        return com.pdftools.sign.SignatureConfiguration.createDynamicObject(retHandle);
    }

    public com.pdftools.sign.SignatureConfiguration readExternalSignature(byte ... signature) {
        if (signature == null) {
            throw new IllegalArgumentException("Argument 'signature' must not be null.", new NullPointerException("'signature'"));
        }
        long retHandle = this.readExternalSignatureNative(this.getHandle(), signature);
        if (retHandle == 0L) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Provider.throwLastRuntimeException();
        }
        return com.pdftools.sign.SignatureConfiguration.createDynamicObject(retHandle);
    }

    public URI getTimestampUrl() {
        String retVal = this.getTimestampUrlNative(this.getHandle());
        if (retVal == null) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Provider.throwLastRuntimeException();
                }
            }
            return null;
        }
        return URI.create(retVal);
    }

    public void setTimestampUrl(URI value) {
        boolean retVal = this.setTimestampUrlNative(this.getHandle(), value != null ? value.toString() : null);
        if (!retVal) {
            switch (Provider.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Provider.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native long createSignatureFromCertificateNative(long var1, Stream var3, String var4);

    private native long createTimestampNative(long var1);

    private native long createPreparedSignatureNative(long var1, int var3, String var4, String var5);

    private native long readExternalSignatureNative(long var1, byte[] var3);

    private native String getTimestampUrlNative(long var1);

    private native boolean setTimestampUrlNative(long var1, String var3);
}

