/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.builtin;

import com.pdftools.crypto.HashAlgorithm;
import com.pdftools.crypto.SignatureFormat;
import com.pdftools.crypto.SignaturePaddingType;
import com.pdftools.crypto.ValidationInformation;

public class SignatureConfiguration
extends com.pdftools.sign.SignatureConfiguration {
    protected SignatureConfiguration(long handle) {
        super(handle);
    }

    public static SignatureConfiguration createDynamicObject(long handle) {
        return new SignatureConfiguration(handle);
    }

    public HashAlgorithm getHashAlgorithm() {
        int retVal = this.getHashAlgorithmNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return HashAlgorithm.fromValue(retVal);
    }

    public void setHashAlgorithm(HashAlgorithm value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setHashAlgorithmNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(SignatureConfiguration.getLastErrorMessage());
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public SignaturePaddingType getSignaturePaddingType() {
        int retVal = this.getSignaturePaddingTypeNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return SignaturePaddingType.fromValue(retVal);
    }

    public void setSignaturePaddingType(SignaturePaddingType value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setSignaturePaddingTypeNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(SignatureConfiguration.getLastErrorMessage());
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public SignatureFormat getSignatureFormat() {
        int retVal = this.getSignatureFormatNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return SignatureFormat.fromValue(retVal);
    }

    public void setSignatureFormat(SignatureFormat value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setSignatureFormatNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public boolean getAddTimestamp() {
        boolean retVal = this.getAddTimestampNative(this.getHandle());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setAddTimestamp(boolean value) {
        boolean retVal = this.setAddTimestampNative(this.getHandle(), value);
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public ValidationInformation getValidationInformation() {
        int retVal = this.getValidationInformationNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return ValidationInformation.fromValue(retVal);
    }

    public void setValidationInformation(ValidationInformation value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setValidationInformationNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    private native int getHashAlgorithmNative(long var1);

    private native boolean setHashAlgorithmNative(long var1, int var3);

    private native int getSignaturePaddingTypeNative(long var1);

    private native boolean setSignaturePaddingTypeNative(long var1, int var3);

    private native int getSignatureFormatNative(long var1);

    private native boolean setSignatureFormatNative(long var1, int var3);

    private native boolean getAddTimestampNative(long var1);

    private native boolean setAddTimestampNative(long var1, boolean var3);

    private native int getValidationInformationNative(long var1);

    private native boolean setValidationInformationNative(long var1, int var3);
}

