/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.globalsigndss;

import com.pdftools.HttpClientHandler;
import com.pdftools.HttpException;
import com.pdftools.PermissionException;
import com.pdftools.RetryException;
import com.pdftools.crypto.providers.Provider;
import com.pdftools.crypto.providers.globalsigndss.SignatureConfiguration;
import com.pdftools.crypto.providers.globalsigndss.TimestampConfiguration;
import java.net.URI;

public class Session
extends Provider {
    protected Session(long handle) {
        super(handle);
    }

    public static Session createDynamicObject(long handle) {
        return new Session(handle);
    }

    public Session(URI url, String api_key, String api_secret, HttpClientHandler httpClientHandler) throws PermissionException, HttpException, RetryException {
        this(Session.newHelper(url, api_key, api_secret, httpClientHandler));
    }

    private static long newHelper(URI url, String api_key, String api_secret, HttpClientHandler httpClientHandler) throws PermissionException, HttpException, RetryException {
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null.", new NullPointerException("'url'"));
        }
        if (api_key == null) {
            throw new IllegalArgumentException("Argument 'api_key' must not be null.", new NullPointerException("'api_key'"));
        }
        if (api_secret == null) {
            throw new IllegalArgumentException("Argument 'api_secret' must not be null.", new NullPointerException("'api_secret'"));
        }
        if (httpClientHandler == null) {
            throw new IllegalArgumentException("Argument 'httpClientHandler' must not be null.", new NullPointerException("'httpClientHandler'"));
        }
        long handle = Session.newNative(url.toString(), api_key, api_secret, Session.getHandle(httpClientHandler), httpClientHandler);
        if (handle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 23: {
                    throw new PermissionException(Session.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Session.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return handle;
    }

    public SignatureConfiguration createSignatureForStaticIdentity() throws PermissionException, HttpException, RetryException {
        long retHandle = this.createSignatureForStaticIdentityNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 23: {
                    throw new PermissionException(Session.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Session.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public SignatureConfiguration createSignatureForDynamicIdentity(String identity) throws PermissionException, HttpException, RetryException {
        if (identity == null) {
            throw new IllegalArgumentException("Argument 'identity' must not be null.", new NullPointerException("'identity'"));
        }
        long retHandle = this.createSignatureForDynamicIdentityNative(this.getHandle(), identity);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 23: {
                    throw new PermissionException(Session.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Session.getLastErrorMessage());
                }
                case 25: {
                    throw new RetryException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public TimestampConfiguration createTimestamp() {
        long retHandle = this.createTimestampNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
        return TimestampConfiguration.createDynamicObject(retHandle);
    }

    private static native long newNative(String var0, String var1, String var2, long var3, HttpClientHandler var5);

    private native long createSignatureForStaticIdentityNative(long var1);

    private native long createSignatureForDynamicIdentityNative(long var1, String var3);

    private native long createTimestampNative(long var1);
}

