/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.pkcs11;

import com.pdftools.crypto.providers.pkcs11.Session;
import com.pdftools.internal.NativeObject;

public class Device
extends NativeObject {
    protected Device(long handle) {
        super(handle);
    }

    public static Device createDynamicObject(long handle) {
        return new Device(handle);
    }

    public Session createSession(String password) {
        long retHandle = this.createSessionNative(this.getHandle(), password);
        if (retHandle == 0L) {
            switch (Device.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Device.throwLastRuntimeException();
        }
        return Session.createDynamicObject(retHandle);
    }

    public String getDescription() {
        String retVal = this.getDescriptionNative(this.getHandle());
        if (retVal == null) {
            switch (Device.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Device.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public String getManufacturerID() {
        String retVal = this.getManufacturerIDNative(this.getHandle());
        if (retVal == null) {
            switch (Device.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Device.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    private native long createSessionNative(long var1, String var3);

    private native String getDescriptionNative(long var1);

    private native String getManufacturerIDNative(long var1);
}

