/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.pkcs11;

import com.pdftools.NotFoundException;
import com.pdftools.crypto.providers.pkcs11.Device;
import com.pdftools.crypto.providers.pkcs11.IndexedIterator;
import com.pdftools.crypto.providers.pkcs11.SubList;
import com.pdftools.internal.NativeObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DeviceList
extends NativeObject
implements List<Device> {
    protected DeviceList(long handle) {
        super(handle);
    }

    public static DeviceList createDynamicObject(long handle) {
        return new DeviceList(handle);
    }

    public Device getSingle() throws NotFoundException {
        long retHandle = this.getSingleNative(this.getHandle());
        if (retHandle == 0L) {
            switch (DeviceList.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 1: {
                    throw new UnsupportedOperationException(DeviceList.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(DeviceList.getLastErrorMessage());
                }
            }
            DeviceList.throwLastRuntimeException();
        }
        return Device.createDynamicObject(retHandle);
    }

    private native long getSingleNative(long var1);

    @Override
    public boolean addAll(Collection<? extends Device> elements) {
        if (elements == null) {
            throw new NullPointerException("'elements'");
        }
        if (elements.isEmpty()) {
            return false;
        }
        for (Device device : elements) {
            this.add(device);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Device> elements) {
        if (elements == null) {
            throw new NullPointerException("'elements'");
        }
        if (elements.isEmpty()) {
            return false;
        }
        for (Device device : elements) {
            this.add(index++, device);
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException("'object'");
        }
        for (Device element : this) {
            if (!element.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object element : objects) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Device> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Device> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Device> listIterator(int index) {
        return new IndexedIterator<Device>(this, index);
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException("'object'");
        }
        int index = this.indexOf(object);
        if (index < 0) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        if (objects == null) {
            throw new NullPointerException("'objects'");
        }
        boolean changed = false;
        for (Object object : objects) {
            changed = this.remove(object) || changed;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        if (objects == null) {
            throw new NullPointerException("'objects'");
        }
        boolean changed = false;
        Iterator<Device> it = this.iterator();
        while (it.hasNext()) {
            if (objects.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public List<Device> subList(int fromIndex, int toIndex) {
        return new SubList<Device>(this, fromIndex, toIndex - fromIndex);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int index = 0; index < this.size(); ++index) {
            array[index] = this.get(index);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        } else if (array.length > size) {
            array[size] = null;
        }
        int i = 0;
        for (Device e : this) {
            array[i] = e;
            ++i;
        }
        return array;
    }

    @Override
    public int size() {
        int n = this.sizeNative(this.getHandle());
        if (n == -1) {
            DeviceList.throwLastRuntimeException(false);
        }
        return n;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Method 'clear' is not supported by this class.");
    }

    @Override
    public int indexOf(Object obj) {
        if (obj == null) {
            throw new NullPointerException("'obj'");
        }
        for (int index = 0; index < this.size(); ++index) {
            if (!obj.equals(this.get(index))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object obj) {
        if (obj == null) {
            throw new NullPointerException("'obj'");
        }
        for (int index = this.size() - 1; index >= 0; --index) {
            if (!obj.equals(this.get(index))) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean add(Device element) {
        throw new UnsupportedOperationException("Method 'add' is not supported by this class.");
    }

    @Override
    public void add(int index, Device element) {
        if (element == null) {
            throw new NullPointerException("'element'");
        }
        if (!this.insertNative(this.getHandle(), index, DeviceList.getHandle(element), element)) {
            DeviceList.throwLastRuntimeException(false);
        }
    }

    @Override
    public Device get(int index) {
        long handle = this.getNative(this.getHandle(), index);
        return this.createObject(handle);
    }

    @Override
    public Device remove(int index) {
        throw new UnsupportedOperationException("Method 'remove' is not supported by this class.");
    }

    @Override
    public Device set(int index, Device element) {
        throw new UnsupportedOperationException("Method 'set' is not supported by this class.");
    }

    protected Device createObject(long handle) {
        if (handle == 0L) {
            DeviceList.throwLastRuntimeException(false);
        }
        return Device.createDynamicObject(handle);
    }

    private native int sizeNative(long var1);

    private native boolean insertNative(long var1, int var3, long var4, Device var6);

    private native long getNative(long var1, int var3);
}

