/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.pkcs11;

import com.pdftools.ExistsException;
import com.pdftools.NotFoundException;
import com.pdftools.PdfToolsException;
import com.pdftools.crypto.providers.pkcs11.DeviceList;
import com.pdftools.internal.NativeObject;
import java.io.IOException;

public class Module
extends NativeObject
implements AutoCloseable {
    protected Module(long handle) {
        super(handle);
    }

    public static Module createDynamicObject(long handle) {
        return new Module(handle);
    }

    public static Module load(String library) throws NotFoundException, ExistsException {
        if (library == null) {
            throw new IllegalArgumentException("Argument 'library' must not be null.", new NullPointerException("'library'"));
        }
        long retHandle = Module.loadNative(library);
        if (retHandle == 0L) {
            switch (Module.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Module.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Module.getLastErrorMessage());
                }
                case 22: {
                    throw new ExistsException(Module.getLastErrorMessage());
                }
            }
            Module.throwLastRuntimeException();
        }
        return Module.createDynamicObject(retHandle);
    }

    public boolean getEnableFullParallelization() {
        boolean retVal = this.getEnableFullParallelizationNative(this.getHandle());
        if (!retVal) {
            switch (Module.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Module.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setEnableFullParallelization(boolean value) {
        boolean retVal = this.setEnableFullParallelizationNative(this.getHandle(), value);
        if (!retVal) {
            switch (Module.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Module.throwLastRuntimeException();
        }
    }

    public DeviceList getDevices() {
        long retHandle = this.getDevicesNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Module.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Module.throwLastRuntimeException();
        }
        return DeviceList.createDynamicObject(retHandle);
    }

    private static native long loadNative(String var0);

    private native boolean getEnableFullParallelizationNative(long var1);

    private native boolean setEnableFullParallelizationNative(long var1, boolean var3);

    private native long getDevicesNative(long var1);

    @Override
    public void close() throws PdfToolsException, IOException {
        try {
            if (!this.close(this.getHandle())) {
                Module.throwLastError();
            }
        }
        finally {
            this.setHandle(0L);
        }
    }

    private native boolean close(long var1);
}

