/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.pkcs11;

import com.pdftools.NotFoundException;
import com.pdftools.PasswordException;
import com.pdftools.PermissionException;
import com.pdftools.crypto.providers.Certificate;
import com.pdftools.crypto.providers.CertificateList;
import com.pdftools.crypto.providers.Provider;
import com.pdftools.crypto.providers.pkcs11.SignatureConfiguration;
import com.pdftools.crypto.providers.pkcs11.TimestampConfiguration;
import com.pdftools.sys.Stream;
import java.net.URI;

public class Session
extends Provider {
    protected Session(long handle) {
        super(handle);
    }

    public static Session createDynamicObject(long handle) {
        return new Session(handle);
    }

    public void login(String password) throws PasswordException, PermissionException {
        boolean retVal = this.loginNative(this.getHandle(), password);
        if (!retVal) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 1: {
                    throw new UnsupportedOperationException(Session.getLastErrorMessage());
                }
                case 17: {
                    throw new PasswordException(Session.getLastErrorMessage());
                }
                case 23: {
                    throw new PermissionException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
    }

    public SignatureConfiguration createSignature(Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("Argument 'certificate' must not be null.", new NullPointerException("'certificate'"));
        }
        long retHandle = this.createSignatureNative(this.getHandle(), Session.getHandle(certificate), certificate);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public SignatureConfiguration createSignatureFromName(String name) throws NotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        long retHandle = this.createSignatureFromNameNative(this.getHandle(), name);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Session.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public SignatureConfiguration createSignatureFromKeyId(byte[] id, Stream certificate) throws NotFoundException {
        if (id == null) {
            throw new IllegalArgumentException("Argument 'id' must not be null.", new NullPointerException("'id'"));
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Argument 'certificate' must not be null.", new NullPointerException("'certificate'"));
        }
        long retHandle = this.createSignatureFromKeyIdNative(this.getHandle(), id, certificate);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Session.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public SignatureConfiguration createSignatureFromKeyLabel(String label, Stream certificate) throws NotFoundException {
        if (label == null) {
            throw new IllegalArgumentException("Argument 'label' must not be null.", new NullPointerException("'label'"));
        }
        if (certificate == null) {
            throw new IllegalArgumentException("Argument 'certificate' must not be null.", new NullPointerException("'certificate'"));
        }
        long retHandle = this.createSignatureFromKeyLabelNative(this.getHandle(), label, certificate);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(Session.getLastErrorMessage());
                }
                case 5: {
                    throw new NotFoundException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public TimestampConfiguration createTimestamp() {
        long retHandle = this.createTimestampNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
        return TimestampConfiguration.createDynamicObject(retHandle);
    }

    public URI getTimestampUrl() {
        String retVal = this.getTimestampUrlNative(this.getHandle());
        if (retVal == null) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    Session.throwLastRuntimeException();
                }
            }
            return null;
        }
        return URI.create(retVal);
    }

    public void setTimestampUrl(URI value) {
        boolean retVal = this.setTimestampUrlNative(this.getHandle(), value != null ? value.toString() : null);
        if (!retVal) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
    }

    public CertificateList getCertificates() {
        long retHandle = this.getCertificatesNative(this.getHandle());
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
        return CertificateList.createDynamicObject(retHandle);
    }

    private native boolean loginNative(long var1, String var3);

    private native long createSignatureNative(long var1, long var3, Certificate var5);

    private native long createSignatureFromNameNative(long var1, String var3);

    private native long createSignatureFromKeyIdNative(long var1, byte[] var3, Stream var4);

    private native long createSignatureFromKeyLabelNative(long var1, String var3, Stream var4);

    private native long createTimestampNative(long var1);

    private native String getTimestampUrlNative(long var1);

    private native boolean setTimestampUrlNative(long var1, String var3);

    private native long getCertificatesNative(long var1);
}

