/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.swisscomsigsrv;

import com.pdftools.HttpClientHandler;
import com.pdftools.HttpException;
import com.pdftools.PermissionException;
import com.pdftools.crypto.providers.Provider;
import com.pdftools.crypto.providers.swisscomsigsrv.SignatureConfiguration;
import com.pdftools.crypto.providers.swisscomsigsrv.StepUp;
import com.pdftools.crypto.providers.swisscomsigsrv.TimestampConfiguration;
import java.net.URI;

public class Session
extends Provider {
    protected Session(long handle) {
        super(handle);
    }

    public static Session createDynamicObject(long handle) {
        return new Session(handle);
    }

    public Session(URI url, HttpClientHandler httpClientHandler) throws PermissionException, HttpException {
        this(Session.newHelper(url, httpClientHandler));
    }

    private static long newHelper(URI url, HttpClientHandler httpClientHandler) throws PermissionException, HttpException {
        if (url == null) {
            throw new IllegalArgumentException("Argument 'url' must not be null.", new NullPointerException("'url'"));
        }
        if (httpClientHandler == null) {
            throw new IllegalArgumentException("Argument 'httpClientHandler' must not be null.", new NullPointerException("'httpClientHandler'"));
        }
        long handle = Session.newNative(url.toString(), Session.getHandle(httpClientHandler), httpClientHandler);
        if (handle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 23: {
                    throw new PermissionException(Session.getLastErrorMessage());
                }
                case 24: {
                    throw new HttpException(Session.getLastErrorMessage());
                }
            }
            Session.throwLastRuntimeException();
        }
        return handle;
    }

    public SignatureConfiguration createSignatureForStaticIdentity(String identity, String name) {
        if (identity == null) {
            throw new IllegalArgumentException("Argument 'identity' must not be null.", new NullPointerException("'identity'"));
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 'name' must not be null.", new NullPointerException("'name'"));
        }
        long retHandle = this.createSignatureForStaticIdentityNative(this.getHandle(), identity, name);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public SignatureConfiguration createSignatureForOnDemandIdentity(String identity, String distinguishedName, StepUp stepUp) {
        if (identity == null) {
            throw new IllegalArgumentException("Argument 'identity' must not be null.", new NullPointerException("'identity'"));
        }
        if (distinguishedName == null) {
            throw new IllegalArgumentException("Argument 'distinguishedName' must not be null.", new NullPointerException("'distinguishedName'"));
        }
        long retHandle = this.createSignatureForOnDemandIdentityNative(this.getHandle(), identity, distinguishedName, Session.getHandle(stepUp), stepUp);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
        return SignatureConfiguration.createDynamicObject(retHandle);
    }

    public TimestampConfiguration createTimestamp(String identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Argument 'identity' must not be null.", new NullPointerException("'identity'"));
        }
        long retHandle = this.createTimestampNative(this.getHandle(), identity);
        if (retHandle == 0L) {
            switch (Session.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            Session.throwLastRuntimeException();
        }
        return TimestampConfiguration.createDynamicObject(retHandle);
    }

    private static native long newNative(String var0, long var1, HttpClientHandler var3);

    private native long createSignatureForStaticIdentityNative(long var1, String var3, String var4);

    private native long createSignatureForOnDemandIdentityNative(long var1, String var3, String var4, long var5, StepUp var7);

    private native long createTimestampNative(long var1, String var3);
}

