/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.swisscomsigsrv;

import com.pdftools.crypto.HashAlgorithm;
import com.pdftools.crypto.SignatureFormat;

public class SignatureConfiguration
extends com.pdftools.sign.SignatureConfiguration {
    protected SignatureConfiguration(long handle) {
        super(handle);
    }

    public static SignatureConfiguration createDynamicObject(long handle) {
        return new SignatureConfiguration(handle);
    }

    public HashAlgorithm getHashAlgorithm() {
        int retVal = this.getHashAlgorithmNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return HashAlgorithm.fromValue(retVal);
    }

    public void setHashAlgorithm(HashAlgorithm value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setHashAlgorithmNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(SignatureConfiguration.getLastErrorMessage());
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public SignatureFormat getSignatureFormat() {
        int retVal = this.getSignatureFormatNative(this.getHandle());
        if (retVal == 0) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return SignatureFormat.fromValue(retVal);
    }

    public void setSignatureFormat(SignatureFormat value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setSignatureFormatNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(SignatureConfiguration.getLastErrorMessage());
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public boolean getAddTimestamp() {
        boolean retVal = this.getAddTimestampNative(this.getHandle());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setAddTimestamp(boolean value) {
        boolean retVal = this.setAddTimestampNative(this.getHandle(), value);
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    public boolean getEmbedValidationInformation() {
        boolean retVal = this.getEmbedValidationInformationNative(this.getHandle());
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    SignatureConfiguration.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setEmbedValidationInformation(boolean value) {
        boolean retVal = this.setEmbedValidationInformationNative(this.getHandle(), value);
        if (!retVal) {
            switch (SignatureConfiguration.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            SignatureConfiguration.throwLastRuntimeException();
        }
    }

    private native int getHashAlgorithmNative(long var1);

    private native boolean setHashAlgorithmNative(long var1, int var3);

    private native int getSignatureFormatNative(long var1);

    private native boolean setSignatureFormatNative(long var1, int var3);

    private native boolean getAddTimestampNative(long var1);

    private native boolean setAddTimestampNative(long var1, boolean var3);

    private native boolean getEmbedValidationInformationNative(long var1);

    private native boolean setEmbedValidationInformationNative(long var1, boolean var3);
}

