/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.crypto.providers.swisscomsigsrv;

import com.pdftools.internal.NativeObject;
import java.net.URI;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Hashtable;

public class StepUp
extends NativeObject {
    private Hashtable<ConsentRequiredListener, ConsentRequiredNativeClass> consentRequiredDic = new Hashtable();

    protected StepUp(long handle) {
        super(handle);
    }

    public static StepUp createDynamicObject(long handle) {
        return new StepUp(handle);
    }

    public void addConsentRequiredListener(ConsentRequiredListener listener) {
        if (!this.consentRequiredDic.containsKey(listener)) {
            ConsentRequiredNativeClass eventNativeClass = new ConsentRequiredNativeClass(listener);
            long context = this.addConsentRequiredHandlerNative(this.getHandle(), eventNativeClass);
            if (context == 0L) {
                StepUp.throwLastRuntimeException();
            }
            eventNativeClass.context = context;
            this.consentRequiredDic.put(listener, eventNativeClass);
        }
    }

    public void removeConsentRequiredListener(ConsentRequiredListener listener) {
        if (this.consentRequiredDic.containsKey(listener)) {
            if (!this.removeConsentRequiredHandlerNative(this.getHandle(), this.consentRequiredDic.get(listener).context) && StepUp.getLastErrorCode() != 5) {
                StepUp.throwLastRuntimeException();
            }
            this.consentRequiredDic.remove(listener);
        }
    }

    public StepUp(String msisdn, String message, String language) {
        this(StepUp.newHelper(msisdn, message, language));
    }

    private static long newHelper(String msisdn, String message, String language) {
        if (msisdn == null) {
            throw new IllegalArgumentException("Argument 'msisdn' must not be null.", new NullPointerException("'msisdn'"));
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must not be null.", new NullPointerException("'message'"));
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 'language' must not be null.", new NullPointerException("'language'"));
        }
        long handle = StepUp.newNative(msisdn, message, language);
        if (handle == 0L) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
        return handle;
    }

    public String getMSISDN() {
        String retVal = this.getMSISDNNative(this.getHandle());
        if (retVal == null) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setMSISDN(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setMSISDNNative(this.getHandle(), value);
        if (!retVal) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
    }

    public String getMessage() {
        String retVal = this.getMessageNative(this.getHandle());
        if (retVal == null) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setMessage(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setMessageNative(this.getHandle(), value);
        if (!retVal) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
    }

    public String getLanguage() {
        String retVal = this.getLanguageNative(this.getHandle());
        if (retVal == null) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
        return retVal;
    }

    public void setLanguage(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setLanguageNative(this.getHandle(), value);
        if (!retVal) {
            switch (StepUp.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            StepUp.throwLastRuntimeException();
        }
    }

    private native long addConsentRequiredHandlerNative(long var1, ConsentRequiredNativeClass var3);

    private native boolean removeConsentRequiredHandlerNative(long var1, long var3);

    private static native long newNative(String var0, String var1, String var2);

    private native String getMSISDNNative(long var1);

    private native boolean setMSISDNNative(long var1, String var3);

    private native String getMessageNative(long var1);

    private native boolean setMessageNative(long var1, String var3);

    private native String getLanguageNative(long var1);

    private native boolean setLanguageNative(long var1, String var3);

    private class ConsentRequiredNativeClass {
        private ConsentRequiredListener listener;
        private long context;

        public ConsentRequiredNativeClass(ConsentRequiredListener listener) {
            this.listener = listener;
        }

        public void consentRequiredHandler(String url) {
            ConsentRequired event = new ConsentRequired(this, url);
            try {
                this.listener.consentRequired(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface ConsentRequiredListener
    extends EventListener {
        public void consentRequired(ConsentRequired var1);
    }

    public class ConsentRequired
    extends EventObject {
        private static final long serialVersionUID = 1563L;
        private URI url;

        private ConsentRequired(Object source, String url) {
            super(source);
            this.url = URI.create(url);
        }

        public URI getUrl() {
            return this.url;
        }
    }
}

