/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.documentassembly;

import com.pdftools.ConformanceException;
import com.pdftools.GenericException;
import com.pdftools.LicenseException;
import com.pdftools.PdfToolsException;
import com.pdftools.ProcessingException;
import com.pdftools.documentassembly.DocumentCopyOptions;
import com.pdftools.documentassembly.PageCopyOptions;
import com.pdftools.internal.NativeObject;
import com.pdftools.pdf.Conformance;
import com.pdftools.pdf.Document;
import com.pdftools.pdf.OutputOptions;
import com.pdftools.sys.Stream;
import java.io.IOException;

public class DocumentAssembler
extends NativeObject
implements AutoCloseable {
    protected DocumentAssembler(long handle) {
        super(handle);
    }

    public static DocumentAssembler createDynamicObject(long handle) {
        return new DocumentAssembler(handle);
    }

    public DocumentAssembler(Stream outStream) throws IOException, GenericException, LicenseException {
        this(outStream, null, null);
    }

    public DocumentAssembler(Stream outStream, OutputOptions outOptions) throws IOException, GenericException, LicenseException {
        this(outStream, outOptions, null);
    }

    public DocumentAssembler(Stream outStream, OutputOptions outOptions, Conformance conformance) throws IOException, GenericException, LicenseException {
        this(DocumentAssembler.newHelper(outStream, outOptions, conformance));
    }

    private static long newHelper(Stream outStream, OutputOptions outOptions, Conformance conformance) throws IOException, GenericException, LicenseException {
        if (outStream == null) {
            throw new IllegalArgumentException("Argument 'outStream' must not be null.", new NullPointerException("'outStream'"));
        }
        long handle = DocumentAssembler.newNative(outStream, DocumentAssembler.getHandle(outOptions), outOptions, conformance == null ? 0 : conformance.getValue(), conformance == null);
        if (handle == 0L) {
            switch (DocumentAssembler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 3: {
                    throw new IllegalArgumentException(DocumentAssembler.getLastErrorMessage());
                }
                case 4: {
                    throw new IOException(DocumentAssembler.getLastErrorMessage());
                }
                case 10: {
                    throw new GenericException(DocumentAssembler.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(DocumentAssembler.getLastErrorMessage());
                }
            }
            DocumentAssembler.throwLastRuntimeException();
        }
        return handle;
    }

    public void append(Document inDoc) throws LicenseException, ConformanceException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        this.append(inDoc, null, null, null, null);
    }

    public void append(Document inDoc, Integer firstPage) throws LicenseException, ConformanceException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        this.append(inDoc, firstPage, null, null, null);
    }

    public void append(Document inDoc, Integer firstPage, Integer lastPage) throws LicenseException, ConformanceException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        this.append(inDoc, firstPage, lastPage, null, null);
    }

    public void append(Document inDoc, Integer firstPage, Integer lastPage, DocumentCopyOptions documentCopyOptions) throws LicenseException, ConformanceException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        this.append(inDoc, firstPage, lastPage, documentCopyOptions, null);
    }

    public void append(Document inDoc, Integer firstPage, Integer lastPage, DocumentCopyOptions documentCopyOptions, PageCopyOptions pageCopyOptions) throws LicenseException, ConformanceException, ProcessingException {
        if (inDoc == null) {
            throw new IllegalArgumentException("Argument 'inDoc' must not be null.", new NullPointerException("'inDoc'"));
        }
        boolean retVal = this.appendNative(this.getHandle(), DocumentAssembler.getHandle(inDoc), inDoc, firstPage, lastPage, DocumentAssembler.getHandle(documentCopyOptions), documentCopyOptions, DocumentAssembler.getHandle(pageCopyOptions), pageCopyOptions);
        if (!retVal) {
            switch (DocumentAssembler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 2: {
                    throw new IllegalStateException(DocumentAssembler.getLastErrorMessage());
                }
                case 3: {
                    throw new IllegalArgumentException(DocumentAssembler.getLastErrorMessage());
                }
                case 12: {
                    throw new LicenseException(DocumentAssembler.getLastErrorMessage());
                }
                case 18: {
                    throw new ConformanceException(DocumentAssembler.getLastErrorMessage());
                }
                case 21: {
                    throw new ProcessingException(DocumentAssembler.getLastErrorMessage());
                }
            }
            DocumentAssembler.throwLastRuntimeException();
        }
    }

    public Document assemble() {
        long retHandle = this.assembleNative(this.getHandle());
        if (retHandle == 0L) {
            switch (DocumentAssembler.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 2: {
                    throw new IllegalStateException(DocumentAssembler.getLastErrorMessage());
                }
            }
            DocumentAssembler.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    private static native long newNative(Stream var0, long var1, OutputOptions var3, int var4, boolean var5);

    private native boolean appendNative(long var1, long var3, Document var5, Integer var6, Integer var7, long var8, DocumentCopyOptions var10, long var11, PageCopyOptions var13);

    private native long assembleNative(long var1);

    @Override
    public void close() throws PdfToolsException, IOException {
        try {
            if (!this.close(this.getHandle())) {
                DocumentAssembler.throwLastError();
            }
        }
        finally {
            this.setHandle(0L);
        }
    }

    private native boolean close(long var1);
}

