/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.documentassembly;

import com.pdftools.internal.NativeObject;

public class DocumentCopyOptions
extends NativeObject {
    protected DocumentCopyOptions(long handle) {
        super(handle);
    }

    public static DocumentCopyOptions createDynamicObject(long handle) {
        return new DocumentCopyOptions(handle);
    }

    public DocumentCopyOptions() {
        this(DocumentCopyOptions.newHelper());
    }

    private static long newHelper() {
        long handle = DocumentCopyOptions.newNative();
        if (handle == 0L) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            DocumentCopyOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public boolean getCopyMetadata() {
        boolean retVal = this.getCopyMetadataNative(this.getHandle());
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    DocumentCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyMetadata(boolean value) {
        boolean retVal = this.setCopyMetadataNative(this.getHandle(), value);
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            DocumentCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyOutputIntent() {
        boolean retVal = this.getCopyOutputIntentNative(this.getHandle());
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    DocumentCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyOutputIntent(boolean value) {
        boolean retVal = this.setCopyOutputIntentNative(this.getHandle(), value);
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            DocumentCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyViewerSettings() {
        boolean retVal = this.getCopyViewerSettingsNative(this.getHandle());
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    DocumentCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyViewerSettings(boolean value) {
        boolean retVal = this.setCopyViewerSettingsNative(this.getHandle(), value);
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            DocumentCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyEmbeddedFiles() {
        boolean retVal = this.getCopyEmbeddedFilesNative(this.getHandle());
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    DocumentCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyEmbeddedFiles(boolean value) {
        boolean retVal = this.setCopyEmbeddedFilesNative(this.getHandle(), value);
        if (!retVal) {
            switch (DocumentCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            DocumentCopyOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native boolean getCopyMetadataNative(long var1);

    private native boolean setCopyMetadataNative(long var1, boolean var3);

    private native boolean getCopyOutputIntentNative(long var1);

    private native boolean setCopyOutputIntentNative(long var1, boolean var3);

    private native boolean getCopyViewerSettingsNative(long var1);

    private native boolean setCopyViewerSettingsNative(long var1, boolean var3);

    private native boolean getCopyEmbeddedFilesNative(long var1);

    private native boolean setCopyEmbeddedFilesNative(long var1, boolean var3);
}

