/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.documentassembly;

import com.pdftools.documentassembly.CopyStrategy;
import com.pdftools.documentassembly.NameConflictResolution;
import com.pdftools.documentassembly.NamedDestinationCopyStrategy;
import com.pdftools.documentassembly.PageRotation;
import com.pdftools.documentassembly.RemovalStrategy;
import com.pdftools.internal.NativeObject;

public class PageCopyOptions
extends NativeObject {
    protected PageCopyOptions(long handle) {
        super(handle);
    }

    public static PageCopyOptions createDynamicObject(long handle) {
        return new PageCopyOptions(handle);
    }

    public PageCopyOptions() {
        this(PageCopyOptions.newHelper());
    }

    private static long newHelper() {
        long handle = PageCopyOptions.newNative();
        if (handle == 0L) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
        return handle;
    }

    public CopyStrategy getLinks() {
        int retVal = this.getLinksNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return CopyStrategy.fromValue(retVal);
    }

    public void setLinks(CopyStrategy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setLinksNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public CopyStrategy getFormFields() {
        int retVal = this.getFormFieldsNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return CopyStrategy.fromValue(retVal);
    }

    public void setFormFields(CopyStrategy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setFormFieldsNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public RemovalStrategy getSignedSignatures() {
        int retVal = this.getSignedSignaturesNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return RemovalStrategy.fromValue(retVal);
    }

    public void setSignedSignatures(RemovalStrategy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setSignedSignaturesNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public CopyStrategy getUnsignedSignatures() {
        int retVal = this.getUnsignedSignaturesNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return CopyStrategy.fromValue(retVal);
    }

    public void setUnsignedSignatures(CopyStrategy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setUnsignedSignaturesNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public CopyStrategy getAnnotations() {
        int retVal = this.getAnnotationsNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return CopyStrategy.fromValue(retVal);
    }

    public void setAnnotations(CopyStrategy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setAnnotationsNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyOutlineItems() {
        boolean retVal = this.getCopyOutlineItemsNative(this.getHandle());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyOutlineItems(boolean value) {
        boolean retVal = this.setCopyOutlineItemsNative(this.getHandle(), value);
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyAssociatedFiles() {
        boolean retVal = this.getCopyAssociatedFilesNative(this.getHandle());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyAssociatedFiles(boolean value) {
        boolean retVal = this.setCopyAssociatedFilesNative(this.getHandle(), value);
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getCopyLogicalStructure() {
        boolean retVal = this.getCopyLogicalStructureNative(this.getHandle());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setCopyLogicalStructure(boolean value) {
        boolean retVal = this.setCopyLogicalStructureNative(this.getHandle(), value);
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public NameConflictResolution getFormFieldConflictResolution() {
        int retVal = this.getFormFieldConflictResolutionNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return NameConflictResolution.fromValue(retVal);
    }

    public void setFormFieldConflictResolution(NameConflictResolution value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setFormFieldConflictResolutionNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public NamedDestinationCopyStrategy getNamedDestinations() {
        int retVal = this.getNamedDestinationsNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return NamedDestinationCopyStrategy.fromValue(retVal);
    }

    public void setNamedDestinations(NamedDestinationCopyStrategy value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setNamedDestinationsNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public boolean getOptimizeResources() {
        boolean retVal = this.getOptimizeResourcesNative(this.getHandle());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return retVal;
    }

    public void setOptimizeResources(boolean value) {
        boolean retVal = this.setOptimizeResourcesNative(this.getHandle(), value);
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    public PageRotation getPageRotation() {
        int retVal = this.getPageRotationNative(this.getHandle());
        if (retVal == 0) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    break;
                }
                default: {
                    PageCopyOptions.throwLastRuntimeException();
                }
            }
        }
        return PageRotation.fromValue(retVal);
    }

    public void setPageRotation(PageRotation value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' must not be null.", new NullPointerException("'value'"));
        }
        boolean retVal = this.setPageRotationNative(this.getHandle(), value.getValue());
        if (!retVal) {
            switch (PageCopyOptions.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
            }
            PageCopyOptions.throwLastRuntimeException();
        }
    }

    private static native long newNative();

    private native int getLinksNative(long var1);

    private native boolean setLinksNative(long var1, int var3);

    private native int getFormFieldsNative(long var1);

    private native boolean setFormFieldsNative(long var1, int var3);

    private native int getSignedSignaturesNative(long var1);

    private native boolean setSignedSignaturesNative(long var1, int var3);

    private native int getUnsignedSignaturesNative(long var1);

    private native boolean setUnsignedSignaturesNative(long var1, int var3);

    private native int getAnnotationsNative(long var1);

    private native boolean setAnnotationsNative(long var1, int var3);

    private native boolean getCopyOutlineItemsNative(long var1);

    private native boolean setCopyOutlineItemsNative(long var1, boolean var3);

    private native boolean getCopyAssociatedFilesNative(long var1);

    private native boolean setCopyAssociatedFilesNative(long var1, boolean var3);

    private native boolean getCopyLogicalStructureNative(long var1);

    private native boolean setCopyLogicalStructureNative(long var1, boolean var3);

    private native int getFormFieldConflictResolutionNative(long var1);

    private native boolean setFormFieldConflictResolutionNative(long var1, int var3);

    private native int getNamedDestinationsNative(long var1);

    private native boolean setNamedDestinationsNative(long var1, int var3);

    private native boolean getOptimizeResourcesNative(long var1);

    private native boolean setOptimizeResourcesNative(long var1, boolean var3);

    private native int getPageRotationNative(long var1);

    private native boolean setPageRotationNative(long var1, int var3);
}

