/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.geometry.units;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Length
implements Comparable<Length> {
    public static final Length ZERO = new Length(0.0);
    public static final Length MAX_VALUE = new Length(Double.MAX_VALUE);
    private double points;

    public Length(double value, Units unit) {
        switch (unit.ordinal()) {
            case 2: {
                this.points = value * 2834645.6692913384;
                break;
            }
            case 0: {
                this.points = value * 2834.6456692913384;
                break;
            }
            case 3: {
                this.points = value * 28.346456692913385;
                break;
            }
            case 4: {
                this.points = value * 2.8346456692913384;
                break;
            }
            case 1: {
                this.points = value;
                break;
            }
            case 5: {
                this.points = value * 72.0;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid unit %s.", new Object[]{unit}));
            }
        }
    }

    public double to(Units unit) {
        switch (unit.ordinal()) {
            case 2: {
                return this.points / 2834645.6692913384;
            }
            case 0: {
                return this.points / 2834.6456692913384;
            }
            case 3: {
                return this.points / 28.346456692913385;
            }
            case 4: {
                return this.points / 2.8346456692913384;
            }
            case 1: {
                return this.points;
            }
            case 5: {
                return this.points / 72.0;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid unit %s.", new Object[]{unit}));
    }

    public Length(double points) {
        this.points = points;
    }

    public double getValue() {
        return this.points;
    }

    public static Length parse(String value) {
        int i;
        for (i = 0; i < value.length() && (Character.isDigit(value.charAt(i)) || value.charAt(i) == '.' || value.charAt(i) == '-'); ++i) {
        }
        double val = Double.parseDouble(value.substring(0, i));
        if (val == 0.0) {
            return ZERO;
        }
        return new Length(val, Units.get(value.substring(i, value.length()).trim()));
    }

    public String toString() {
        double metre = this.to(Units.METRE);
        return metre >= 1.0 ? String.valueOf(metre) + "m" : (metre >= 0.01 ? String.valueOf(metre * 100.0) + "cm" : String.valueOf(metre * 1000.0) + "mm");
    }

    public String toString(Units unit) {
        return String.valueOf(this.to(unit)) + unit.getSymbol();
    }

    public static Length[] parseArray(String value, int size) {
        Length[] arr = Length.parseArray(value);
        if (arr.length != size) {
            throw new IllegalArgumentException("value must contain exactly " + size + " components");
        }
        return arr;
    }

    public static Length[] parseArray(String value) {
        ArrayList<Length> lengthArray = new ArrayList<Length>();
        for (String string : value.trim().split("\\s+")) {
            lengthArray.add(Length.parse(string));
        }
        Length[] arr = new Length[lengthArray.size()];
        return lengthArray.toArray(arr);
    }

    public Length add(Length addend) {
        return new Length(this.points + addend.points);
    }

    public Length subtract(Length subtrahend) {
        return new Length(this.points - subtrahend.points);
    }

    public Length multiply(double multiplicand) {
        return new Length(this.points * multiplicand);
    }

    public Length divide(double divisor) {
        return new Length(this.points / divisor);
    }

    public double divide(Length divisor) {
        return this.points / divisor.points;
    }

    public static Length min(Length lhs, Length rhs) {
        return new Length(Math.min(lhs.points, rhs.points));
    }

    public static Length max(Length lhs, Length rhs) {
        return new Length(Math.max(lhs.points, rhs.points));
    }

    public static Length abs(Length length) {
        return new Length(Math.abs(length.points));
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Length) {
            return ((Length)obj).points == this.points;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.points);
    }

    @Override
    public int compareTo(Length o) {
        return Double.compare(this.points, o.points);
    }

    public static enum Units {
        METRE("m"),
        POINT("pt"),
        KILOMETRE("km"),
        CENTIMETRE("cm"),
        MILLIMETRE("mm"),
        INCH("in");

        private String unit;
        private static final Map<String, Units> symbols;

        private Units(String unit) {
            this.unit = unit;
        }

        public String getSymbol() {
            return this.unit;
        }

        public String toString() {
            return this.getSymbol();
        }

        public static Units get(String symbol) {
            Units u = symbols.get(symbol.toLowerCase());
            if (u == null) {
                throw new IllegalArgumentException(String.format("Invalid unit symbol %s.", symbol));
            }
            return u;
        }

        static {
            ConcurrentHashMap<String, Units> map = new ConcurrentHashMap<String, Units>();
            for (Units instance : Units.values()) {
                map.put(instance.getSymbol(), instance);
            }
            symbols = Collections.unmodifiableMap(map);
        }
    }
}

