/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.geometry.units;

import com.pdftools.geometry.units.Length;
import java.util.Objects;

public class Margin {
    private double left;
    private double bottom;
    private double right;
    private double top;

    public Margin(double left, double bottom, double right, double top) {
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.top = top;
    }

    public double getLeftValue() {
        return this.left;
    }

    public double getBottomValue() {
        return this.bottom;
    }

    public double getRightValue() {
        return this.right;
    }

    public double getTopValue() {
        return this.top;
    }

    public Margin(Length left, Length bottom, Length right, Length top) {
        this(left.getValue(), bottom.getValue(), right.getValue(), top.getValue());
    }

    public Margin(double left, double bottom, double right, double top, Length.Units unit) {
        this(new Length(left, unit), new Length(bottom, unit), new Length(right, unit), new Length(top, unit));
    }

    public Margin(Length margin) {
        this(margin.getValue(), margin.getValue(), margin.getValue(), margin.getValue());
    }

    public Margin(double margin, Length.Units unit) {
        Length l = new Length(margin, unit);
        this.left = l.getValue();
        this.bottom = l.getValue();
        this.right = l.getValue();
        this.top = l.getValue();
    }

    public static Margin parse(String value) {
        Length[] lengths = Length.parseArray(value, 4);
        return new Margin(lengths[0], lengths[1], lengths[2], lengths[3]);
    }

    public String toString() {
        return this.getLeft().toString() + " " + this.getBottom().toString() + " " + this.getRight().toString() + " " + this.getTop().toString();
    }

    public String toString(Length.Units unit) {
        return this.getLeft().toString(unit) + " " + this.getBottom().toString(unit) + " " + this.getRight().toString(unit) + " " + this.getTop().toString(unit);
    }

    public Length getLeft() {
        return new Length(this.left, Length.Units.POINT);
    }

    public Length getBottom() {
        return new Length(this.bottom, Length.Units.POINT);
    }

    public Length getRight() {
        return new Length(this.right, Length.Units.POINT);
    }

    public Length getTop() {
        return new Length(this.top, Length.Units.POINT);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Margin) {
            if (((Margin)obj).left != this.left) {
                return false;
            }
            if (((Margin)obj).bottom != this.bottom) {
                return false;
            }
            if (((Margin)obj).right != this.right) {
                return false;
            }
            return ((Margin)obj).top == this.top;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.bottom, this.right, this.top);
    }
}

