/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.geometry.units;

import com.pdftools.geometry.units.Length;
import java.util.Objects;

public class Point {
    private double x;
    private double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getXValue() {
        return this.x;
    }

    public double getYValue() {
        return this.y;
    }

    public Point(Length x, Length y) {
        this(x.getValue(), y.getValue());
    }

    public static Point parse(String value) {
        Length[] lengths = Length.parseArray(value, 2);
        return new Point(lengths[0], lengths[1]);
    }

    public String toString() {
        return this.getX().toString() + " " + this.getY().toString();
    }

    public String toString(Length.Units unit) {
        return this.getX().toString(unit) + " " + this.getY().toString(unit);
    }

    public Length getX() {
        return new Length(this.x, Length.Units.POINT);
    }

    public Length getY() {
        return new Length(this.y, Length.Units.POINT);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Point) {
            if (((Point)obj).x != this.x) {
                return false;
            }
            return ((Point)obj).y == this.y;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }
}

