/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.geometry.units;

import com.pdftools.geometry.units.Length;
import com.pdftools.geometry.units.Point;
import com.pdftools.geometry.units.Size;
import java.util.Objects;

public class Rectangle {
    private double x;
    private double y;
    private double width;
    private double height;

    public Rectangle(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public double getXValue() {
        return this.x;
    }

    public double getYValue() {
        return this.y;
    }

    public double getWidthValue() {
        return this.width;
    }

    public double getHeightValue() {
        return this.height;
    }

    public Rectangle(Length x, Length y, Length width, Length height) {
        this(x.getValue(), y.getValue(), width.getValue(), height.getValue());
    }

    public Rectangle(double x, double y, double width, double height, Length.Units unit) {
        this(new Length(x, unit), new Length(y, unit), new Length(width, unit), new Length(height, unit));
    }

    public static Rectangle fromEdges(Length left, Length bottom, Length right, Length top) {
        return new Rectangle(left, bottom, right.subtract(left), top.subtract(bottom));
    }

    public static Rectangle parse(String value) {
        Length[] lengths = Length.parseArray(value, 4);
        return new Rectangle(lengths[0], lengths[1], lengths[2], lengths[3]);
    }

    public String toString() {
        return this.getPosition().toString() + " " + this.getSize().toString();
    }

    public String toString(Length.Units unit) {
        return this.getPosition().toString(unit) + " " + this.getSize().toString(unit);
    }

    public boolean contains(Rectangle other) {
        Rectangle thisNorm = this.normalize();
        Rectangle otherNorm = other.normalize();
        return thisNorm.getLeft().getValue() <= otherNorm.getLeft().getValue() && thisNorm.getRight().getValue() >= otherNorm.getRight().getValue() && thisNorm.getTop().getValue() >= otherNorm.getTop().getValue() && thisNorm.getBottom().getValue() <= otherNorm.getBottom().getValue();
    }

    private Rectangle normalize() {
        double normalizedLeft = Math.min(this.getLeft().getValue(), this.getRight().getValue());
        double normalizedRight = Math.max(this.getLeft().getValue(), this.getRight().getValue());
        double normalizedBottom = Math.min(this.getBottom().getValue(), this.getTop().getValue());
        double normalizedTop = Math.max(this.getBottom().getValue(), this.getTop().getValue());
        return new Rectangle(normalizedLeft, normalizedBottom, normalizedRight - normalizedLeft, normalizedTop - normalizedLeft);
    }

    public Point getPosition() {
        return new Point(new Length(this.x, Length.Units.POINT), new Length(this.y, Length.Units.POINT));
    }

    public Size getSize() {
        return new Size(new Length(this.width, Length.Units.POINT), new Length(this.height, Length.Units.POINT));
    }

    public Length getLeft() {
        return this.getPosition().getX();
    }

    public Length getTop() {
        return this.getPosition().getY().add(this.getSize().getHeight());
    }

    public Length getRight() {
        return this.getPosition().getX().add(this.getSize().getWidth());
    }

    public Length getBottom() {
        return this.getPosition().getY();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Rectangle) {
            if (((Rectangle)obj).x != this.x) {
                return false;
            }
            if (((Rectangle)obj).y != this.y) {
                return false;
            }
            if (((Rectangle)obj).width != this.width) {
                return false;
            }
            return ((Rectangle)obj).height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.width, this.height);
    }
}

