/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.geometry.units;

import com.pdftools.geometry.units.Length;
import com.pdftools.geometry.units.Size;
import java.util.Objects;

public class Resolution {
    public double xDpi;
    public double yDpi;

    public Resolution(double xDpi, double yDpi) {
        this.xDpi = xDpi;
        this.yDpi = yDpi;
    }

    public Resolution(double dpi) {
        this.xDpi = dpi;
        this.yDpi = dpi;
    }

    public double getXDpi() {
        return this.xDpi;
    }

    public void setXDpi(double xDpi) {
        this.xDpi = xDpi;
    }

    public double getYDpi() {
        return this.yDpi;
    }

    public void setYDpi(double yDpi) {
        this.yDpi = yDpi;
    }

    public Size calculateSize(com.pdftools.geometry.integer.Size pixels) {
        return new Size((double)pixels.getWidth() / this.xDpi * 72.0, (double)pixels.getHeight() / this.yDpi * 72.0, Length.Units.POINT);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Resolution) {
            if (((Resolution)obj).xDpi != this.xDpi) {
                return false;
            }
            return ((Resolution)obj).yDpi == this.yDpi;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.xDpi, this.yDpi);
    }

    public String toString() {
        return String.format("%fDPI %fDPI", this.xDpi, this.yDpi);
    }
}

