/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.geometry.units;

import com.pdftools.geometry.units.Length;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Size {
    private double width;
    private double height;

    public Size(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public double getWidthValue() {
        return this.width;
    }

    public double getHeightValue() {
        return this.height;
    }

    public Size(Length width, Length height) {
        this(width.getValue(), height.getValue());
    }

    public Size(double width, double height, Length.Units unit) {
        this(new Length(width, unit), new Length(height, unit));
    }

    public Size(PaperSizes paperSize) {
        Size size = Size.getStandardSize(paperSize);
        this.width = size.width;
        this.height = size.height;
    }

    private static Size getStandardSize(PaperSizes paperSize) {
        switch (paperSize.ordinal()) {
            case 0: {
                return new Size(new Length(0.297, Length.Units.METRE), new Length(0.42, Length.Units.METRE));
            }
            case 1: {
                return new Size(new Length(0.21, Length.Units.METRE), new Length(0.297, Length.Units.METRE));
            }
            case 2: {
                return new Size(new Length(0.148, Length.Units.METRE), new Length(0.21, Length.Units.METRE));
            }
            case 3: {
                return new Size(new Length(8.5, Length.Units.INCH), new Length(11.0, Length.Units.INCH));
            }
            case 4: {
                return new Size(new Length(8.5, Length.Units.INCH), new Length(14.0, Length.Units.INCH));
            }
        }
        throw new IllegalArgumentException("PaperSize " + paperSize.toString() + " not supported.");
    }

    public static Size parse(String value) {
        try {
            return new Size(PaperSizes.get(value));
        }
        catch (IllegalArgumentException ex) {
            Length[] lengths = Length.parseArray(value, 2);
            return new Size(lengths[0], lengths[1]);
        }
    }

    public String toString() {
        return this.getWidth().toString() + " " + this.getHeight().toString();
    }

    public String toString(Length.Units unit) {
        return this.getWidth().toString(unit) + " " + this.getHeight().toString(unit);
    }

    public Size toPortrait() {
        if (Math.abs(this.width) > Math.abs(this.height)) {
            return new Size(this.height, this.width);
        }
        return this;
    }

    public Size toLandscape() {
        if (Math.abs(this.height) > Math.abs(this.width)) {
            return new Size(this.height, this.width);
        }
        return this;
    }

    public double getAspectRatio() {
        return Math.abs(this.height) / Math.abs(this.width);
    }

    public Length getWidth() {
        return new Length(this.width, Length.Units.POINT);
    }

    public Length getHeight() {
        return new Length(this.height, Length.Units.POINT);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Size) {
            if (((Size)obj).width != this.width) {
                return false;
            }
            return ((Size)obj).height == this.height;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.width, this.height);
    }

    public static enum PaperSizes {
        A3("A3"),
        A4("A4"),
        A5("A5"),
        LETTER("Letter"),
        LEGAL("Legal");

        private String paperSize;
        private static final Map<String, PaperSizes> names;

        private PaperSizes(String paperSize) {
            this.paperSize = paperSize;
        }

        public String getName() {
            return this.paperSize;
        }

        public String toString() {
            return this.getName();
        }

        public static PaperSizes get(String name) {
            PaperSizes ps = names.get(name);
            if (ps == null) {
                throw new IllegalArgumentException(String.format("Invalid paper size name %s.", name));
            }
            return ps;
        }

        static {
            ConcurrentHashMap<String, PaperSizes> map = new ConcurrentHashMap<String, PaperSizes>();
            for (PaperSizes instance : PaperSizes.values()) {
                map.put(instance.getName(), instance);
            }
            names = Collections.unmodifiableMap(map);
        }
    }
}

