/*
 * Decompiled with CFR 0.152.
 */
package com.pdftools.image;

import com.pdftools.CorruptException;
import com.pdftools.LicenseException;
import com.pdftools.PdfToolsException;
import com.pdftools.UnknownFormatException;
import com.pdftools.image.MultiPageDocument;
import com.pdftools.image.SinglePageDocument;
import com.pdftools.internal.NativeObject;
import com.pdftools.sys.Stream;
import java.io.IOException;

public abstract class Document
extends NativeObject
implements AutoCloseable {
    protected Document(long handle) {
        super(handle);
    }

    public static Document createDynamicObject(long handle) {
        int type = Document.getType(handle);
        switch (type) {
            case 1: {
                return SinglePageDocument.createDynamicObject(handle);
            }
            case 2: {
                return MultiPageDocument.createDynamicObject(handle);
            }
        }
        return null;
    }

    public static Document open(Stream stream) throws LicenseException, UnknownFormatException, CorruptException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument 'stream' must not be null.", new NullPointerException("'stream'"));
        }
        long retHandle = Document.openNative(stream);
        if (retHandle == 0L) {
            switch (Document.getLastErrorCode()) {
                case 0: {
                    throw new RuntimeException("An unexpected error occurred");
                }
                case 12: {
                    throw new LicenseException(Document.getLastErrorMessage());
                }
                case 15: {
                    throw new UnknownFormatException(Document.getLastErrorMessage());
                }
                case 16: {
                    throw new CorruptException(Document.getLastErrorMessage());
                }
            }
            Document.throwLastRuntimeException();
        }
        return Document.createDynamicObject(retHandle);
    }

    private static native int getType(long var0);

    private static native long openNative(Stream var0);

    @Override
    public void close() throws PdfToolsException, IOException {
        try {
            if (!this.close(this.getHandle())) {
                Document.throwLastError();
            }
        }
        finally {
            this.setHandle(0L);
        }
    }

    private native boolean close(long var1);
}

